/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth1.wizard;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Oauth1Bean {
    private final Logger logger = LogManager.getLogger(this.getClass());
    String consumerKey;
    String consumerSecret;
    String signatureMethod;
    RequestTokenBean requestTokenBean = new RequestTokenBean();
    AuthorizationBean authorizationBean = new AuthorizationBean();
    AccessTokenBean accessTokenBean = new AccessTokenBean();
    RequestTokenResponse requestTokenResponse = new RequestTokenResponse();
    AccessTokenResponse accessTokenResponse = new AccessTokenResponse();

    private String generateTimestamp() {
        Date d = new Date();
        return "" + d.getTime() / 1000L;
    }

    private String generateNonce() {
        SecureRandom gen = new SecureRandom();
        ((Random)gen).setSeed(System.currentTimeMillis());
        StringBuilder nonceBuilder = new StringBuilder("");
        String base = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int baseLength = base.length();
        int i = 0;
        while (i < 32) {
            int position = gen.nextInt(baseLength);
            nonceBuilder.append(base.charAt(position));
            ++i;
        }
        return nonceBuilder.toString();
    }

    public Oauth1Bean(String consumerKey, String consumerSecret, String signatureMethod) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.signatureMethod = signatureMethod;
    }

    public Oauth1Bean() {
    }

    public void setTokenRequestResponse(String response) throws Exception {
        String[] p;
        this.requestTokenResponse = new RequestTokenResponse();
        String[] stringArray = p = response.split("\\&");
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] ss = s.split("=");
            if (ss[0].equals("oauth_token")) {
                this.requestTokenResponse.oauthToken = ss[1];
            } else if (ss[0].equals("oauth_token_secret")) {
                this.requestTokenResponse.oauthTokenSecret = ss[1];
            }
            ++n2;
        }
        if (this.requestTokenResponse.oauthToken == null || this.requestTokenResponse.oauthTokenSecret == null) {
            throw new Exception("Missing OAauth token response in the server response {" + response + "}");
        }
    }

    public void setTokenAccessResponse(String response) throws Exception {
        String[] p;
        this.accessTokenResponse = new AccessTokenResponse();
        this.accessTokenResponse.response = response;
        String[] stringArray = p = response.split("\\&");
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] ss = s.split("=");
            if (ss[0].equals("oauth_token")) {
                this.accessTokenResponse.oauthToken = ss[1];
            } else if (ss[0].equals("oauth_token_secret")) {
                this.accessTokenResponse.oauthTokenSecret = ss[1];
            }
            ++n2;
        }
        if (this.accessTokenResponse.oauthToken == null || this.accessTokenResponse.oauthTokenSecret == null) {
            throw new Exception("Missing OAauth token response in the server response {" + response + "}");
        }
    }

    public class AccessTokenBean {
        String url = "";
        String httpMethod = "";
        String oauth_verifier;
        List<ParameterBean> oAuthParams = new ArrayList<ParameterBean>();

        void generateAuthorizationHeaderParameters() {
            this.oAuthParams = new ArrayList<ParameterBean>();
            this.oAuthParams.add(new ParameterBean("oauth_consumer_key", Oauth1Bean.this.consumerKey));
            this.oAuthParams.add(new ParameterBean("oauth_nonce", Oauth1Bean.this.generateNonce()));
            this.oAuthParams.add(new ParameterBean("oauth_timestamp", Oauth1Bean.this.generateTimestamp()));
            this.oAuthParams.add(new ParameterBean("oauth_signature_method", Oauth1Bean.this.signatureMethod));
            this.oAuthParams.add(new ParameterBean("oauth_version", "1.0"));
            this.oAuthParams.add(new ParameterBean("oauth_verifier", this.oauth_verifier));
            this.oAuthParams.add(new ParameterBean("oauth_token", Oauth1Bean.this.requestTokenResponse.oauthToken));
        }

        public Collection<? extends ParameterBean> getAutorizationHeaderParameters() {
            return this.oAuthParams;
        }
    }

    public class AccessTokenResponse {
        String oauthToken;
        String oauthTokenSecret;
        String response;

        public void dump() {
            Oauth1Bean.this.logger.debug(this.response);
        }
    }

    public class AuthorizationBean {
        String url = "";
        String callBackURL = null;
        List<ParameterBean> additionalParams = new ArrayList<ParameterBean>();
    }

    public static class ParameterBean {
        String name = "parameter";
        String value = "";

        public ParameterBean() {
        }

        public ParameterBean(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public class RequestTokenBean {
        String url = "";
        String httpMethod = "";
        List<ParameterBean> additionalParams = new ArrayList<ParameterBean>();
        List<ParameterBean> oAuthParams = new ArrayList<ParameterBean>();

        void generateAuthorizationHeaderParameters() {
            this.oAuthParams = new ArrayList<ParameterBean>();
            this.oAuthParams.add(new ParameterBean("oauth_consumer_key", Oauth1Bean.this.consumerKey));
            this.oAuthParams.add(new ParameterBean("oauth_nonce", Oauth1Bean.this.generateNonce()));
            this.oAuthParams.add(new ParameterBean("oauth_timestamp", Oauth1Bean.this.generateTimestamp()));
            this.oAuthParams.add(new ParameterBean("oauth_signature_method", Oauth1Bean.this.signatureMethod));
            this.oAuthParams.add(new ParameterBean("oauth_version", "1.0"));
            if (Oauth1Bean.this.authorizationBean.callBackURL != null) {
                this.oAuthParams.add(new ParameterBean("oauth_callback", Oauth1Bean.this.authorizationBean.callBackURL));
            }
        }

        public Collection<? extends ParameterBean> getAutorizationHeaderParameters() {
            return this.oAuthParams;
        }
    }

    public class RequestTokenResponse {
        String oauthToken;
        String oauthTokenSecret;
    }
}

