/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.httprest.Messages;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AuthorizationCodeGrantBean {
    private static final Logger logger = LogManager.getLogger(AuthorizationCodeGrantBean.class);
    List<Preconf> preconfs = new ArrayList<Preconf>();
    static final List<ScopeProvider> scopeProvider = new ArrayList<ScopeProvider>();
    static Image linkedInImg;
    static Image googleImg;
    static final Preconf linkedInConf;
    static final Preconf googleConf;
    static final Preconf salesForceConf;
    String clientId = "";
    String clientSecret = "";
    String authorizationURI = "";
    String tokenURI = "";
    String redirectURI = "http://localhost";
    String token = "";
    String expiresIn = "";
    String refreshToken = "";
    Map<String, String> responseInfo = new HashMap<String, String>();
    String name = "";
    List<String> scopes = new ArrayList<String>();
    HashMap<String, String> authParams = new HashMap();
    HashMap<String, String> additionalHeaders = new HashMap();
    boolean isImplicit = false;
    private boolean changed = false;
    boolean enableHostnameVerification;
    boolean enableCertificateVerification;

    static {
        try {
            linkedInImg = ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.addons/icons/linkedin_16x16.png")).createImage();
        }
        catch (Exception e) {
            logger.warn("Failed to load image", (Throwable)e);
        }
        try {
            googleImg = ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.addons/icons/google_16x16.png")).createImage();
        }
        catch (Exception e) {
            logger.warn("Failed to load image", (Throwable)e);
        }
        ScopeProvider p = new ScopeProvider("LinkedIn", linkedInImg);
        p.scope.put("r_basicprofile", "");
        p.scope.put("r_emailaddress", "");
        p.scope.put("rw_company_admin", "");
        p.scope.put("w_share", "");
        scopeProvider.add(p);
        p = new ScopeProvider("BigQuery API - v2", googleImg);
        p.scope.put("https://www.googleapis.com/auth/bigquery", Messages.AuthorizationCodeGrantBean_13);
        p.scope.put("https://www.googleapis.com/auth/bigquery.insertdata", Messages.AuthorizationCodeGrantBean_15);
        p.scope.put("https://www.googleapis.com/auth/cloud-platform", Messages.AuthorizationCodeGrantBean_17);
        p.scope.put("https://www.googleapis.com/auth/cloud-platform.read-only", Messages.AuthorizationCodeGrantBean_19);
        p.scope.put("https://www.googleapis.com/auth/devstorage.full_control", Messages.AuthorizationCodeGrantBean_21);
        p.scope.put("https://www.googleapis.com/auth/devstorage.read_only", Messages.AuthorizationCodeGrantBean_23);
        p.scope.put("https://www.googleapis.com/auth/devstorage.read_write", Messages.AuthorizationCodeGrantBean_25);
        scopeProvider.add(p);
        p = new ScopeProvider(Messages.AuthorizationCodeGrantBean_26, googleImg);
        p.scope.put("https://mail.google.com/", Messages.AuthorizationCodeGrantBean_28);
        p.scope.put("https://www.googleapis.com/auth/gmail.send", Messages.AuthorizationCodeGrantBean_30);
        scopeProvider.add(p);
        linkedInConf = new Preconf(Messages.AuthorizationCodeGrantBean_31, "https://www.linkedin.com/uas/oauth2/authorization", "https://www.linkedin.com/oauth/v2/accessToken", false, false);
        googleConf = new Preconf(Messages.AuthorizationCodeGrantBean_34, "https://accounts.google.com/o/oauth2/v2/auth", "https://www.googleapis.com/oauth2/v4/token", false, false);
        salesForceConf = new Preconf(Messages.AuthorizationCodeGrantBean_37, "https://login.salesforce.com/services/oauth2/authorize", "https://login.salesforce.com/services/oauth2/token", true, true);
    }

    public void changed() {
        this.changed = true;
        this.token = "";
        this.expiresIn = "";
        this.refreshToken = "";
        this.responseInfo.clear();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean hasToken() {
        return this.token != null && !this.token.trim().isEmpty();
    }

    public static class Preconf {
        String authorizationEndPoint;
        String tokenEndPoint;
        String name;
        boolean includeClientId;
        boolean includeClientSecret;

        Preconf(String name, String auth, String token, boolean includeClientId, boolean includeClientSecret) {
            this.name = name;
            this.authorizationEndPoint = auth;
            this.tokenEndPoint = token;
            this.includeClientId = includeClientId;
            this.includeClientSecret = includeClientSecret;
        }
    }

    public static class ScopeProvider {
        String name;
        Image img;
        HashMap<String, String> scope = new HashMap();

        ScopeProvider(String name, Image img) {
            this.name = name;
            this.img = img;
        }

        public Image getImage() {
            return this.img;
        }
    }
}

