/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth2.wizard.AbstractGrantFlow;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantBean;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantBean;
import com.indy.addons.oauth2.wizard.SecretsResolver;
import com.indy.addons.oauth2.wizard.URLParser;
import com.indy.ui.conf.custom.Activator;
import com.indy.ui.conf.custom.preference.ConfPreferencePage;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthorizationCodeGrantFlow {
    private final Logger logger = LogManager.getLogger(this.getClass());
    AuthorizationCodeGrantBean bean;

    AuthorizationCodeGrantFlow(AuthorizationCodeGrantBean bean) {
        this.bean = bean;
    }

    public AccessTokenResponse getToken(IWizard w) throws Exception {
        String url = this.bean.authorizationURI;
        Map<String, String> queryParam = this.getAuthorizationEndpointQueryParam();
        final BrowserDialog d = new BrowserDialog();
        HttpServer server = null;
        HttpContext ctx = null;
        int port = Activator.getDefault().getPreferenceStore().getInt("com.indy.ui.conf.custom.preference.localHttpServer.port");
        boolean startServer = this.bean.redirectURI.contains("localhost");
        if (startServer) {
            try {
                InetSocketAddress add = new InetSocketAddress("localhost", port);
                server = HttpServer.create(add, 0);
                ctx = server.createContext("/", new HttpHandler(){

                    @Override
                    public void handle(HttpExchange t) throws IOException {
                        d.handledRedirectionQuery = AuthorizationCodeGrantFlow.this.bean.redirectURI + t.getRequestURI().toString();
                        t.getResponseHeaders().add("Location", (String)d.handledRedirectionQuery);
                        t.sendResponseHeaders(203, 1L);
                        d.close();
                    }
                });
                server.setExecutor(null);
                server.start();
            }
            catch (BindException ex) {
                if (!MessageDialog.open((int)3, (Shell)w.getContainer().getShell(), (String)Messages.AuthorizationCodeGrantFlow_12, (String)NLS.bind((String)Messages.AuthorizationCodeGrantFlow_13, (Object)port), (int)4)) {
                    return null;
                }
            }
            catch (Exception ex) {
                if (server != null) {
                    if (ctx != null) {
                        server.removeContext(ctx);
                    }
                    server.stop(1);
                }
                throw ex;
            }
        }
        ArrayList<CallSite> headers = new ArrayList<CallSite>();
        if (this.bean.additionalHeaders != null) {
            for (Map.Entry<String, String> entry : this.bean.additionalHeaders.entrySet()) {
                headers.add((CallSite)((Object)(entry.getKey() + ": " + entry.getValue())));
            }
        }
        URI uriWithParam = new URIBuilder(url).addParameters(queryParam.entrySet().stream().map(p -> new BasicNameValuePair((String)p.getKey(), (String)p.getValue())).map(NameValuePair.class::cast).toList()).build();
        d.open(w.getContainer().getShell(), uriWithParam.toString(), headers.toArray(new String[0]));
        try {
            if (server != null) {
                if (ctx != null) {
                    server.removeContext(ctx);
                }
                server.stop(1);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Error while stopping the local http server", (Throwable)ex);
        }
        if (d.handledRedirectionQuery != null) {
            String error;
            if (this.bean.isImplicit) {
                URLParser p2 = new URLParser(d.handledRedirectionQuery, URLParser.MODE_FRAGMENT);
                HashMap<String, String> res = new HashMap<String, String>();
                for (String s : p2.getParameters()) {
                    res.put(s, p2.getParameter(s));
                }
                return new AccessTokenResponse(res);
            }
            URLParser p3 = new URLParser(d.handledRedirectionQuery, URLParser.MODE_PARAMETER);
            String code = p3.getParameter("code");
            if (code == null && (error = p3.getParameter("error")) != null) {
                StringBuilder b = new StringBuilder();
                for (String s : p3.getParameters()) {
                    if (s.equals("error")) continue;
                    b.append(s + ": " + p3.getParameter(s) + "\n");
                }
                throw new Exception(Messages.AuthorizationCodeGrantFlow_21 + error + "\n" + b.toString());
            }
            GrantFlow flow = new GrantFlow(this.bean, code);
            return flow.getToken();
        }
        return null;
    }

    private Map<String, String> getAuthorizationEndpointQueryParam() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.bean.isImplicit) {
            params.put("response_type", "token");
        } else {
            params.put("response_type", "code");
        }
        params.put("client_id", new SecretsResolver().resolveSecrets(this.bean.clientId)[0]);
        if (!this.bean.redirectURI.trim().isEmpty()) {
            params.put("redirect_uri", this.bean.redirectURI);
        }
        params.put("state", UUID.randomUUID().toString());
        if (this.bean.authParams != null) {
            params.putAll(this.bean.authParams);
        }
        params.put("scope", String.join((CharSequence)" ", this.bean.scopes));
        return params;
    }

    public static class AccessTokenResponse {
        String token;
        String tokenType;
        String expireIn;
        String refreshToken;
        Map<String, String> allInfos;

        public AccessTokenResponse(Map<String, String> m) {
            this.token = m.remove("access_token");
            this.tokenType = m.remove("token_type");
            this.expireIn = m.remove("expires_in");
            this.refreshToken = m.remove("refresh_token");
            this.allInfos = m;
        }
    }

    private class BrowserDialog {
        Text url;
        String handledRedirectionQuery;
        Shell sh = null;

        private BrowserDialog() {
        }

        public void open(Shell parent, String url, String[] headers) {
            this.sh = new Shell(parent, 112);
            this.sh.setText(Messages.AuthorizationCodeGrantFlow_0);
            this.sh.setSize(800, 600);
            this.sh.setLayout((Layout)new GridLayout());
            this.url = new Text((Composite)this.sh, 2048);
            this.url.setLayoutData((Object)new GridData(4, 1, true, false));
            this.url.setEditable(false);
            Browser b = new Browser((Composite)this.sh, 0);
            b.setLayoutData((Object)new GridData(1808));
            b.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    ((BrowserDialog)BrowserDialog.this).AuthorizationCodeGrantFlow.this.logger.debug(event.location);
                }

                public void changed(LocationEvent event) {
                    BrowserDialog.this.url.setText(event.location);
                    if (event.location.startsWith(((BrowserDialog)BrowserDialog.this).AuthorizationCodeGrantFlow.this.bean.redirectURI)) {
                        BrowserDialog.this.handledRedirectionQuery = event.location;
                        BrowserDialog.this.sh.close();
                    }
                }
            });
            b.setUrl(url, null, headers);
            this.sh.open();
            Display display = this.sh.getDisplay();
            Shell loopShell = this.sh;
            while (!loopShell.isDisposed()) {
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                catch (Exception ex) {
                    AuthorizationCodeGrantFlow.this.logger.debug("unexpected", (Throwable)ex);
                }
            }
            if (!display.isDisposed()) {
                display.update();
            }
        }

        public void close() {
            Display.getCurrent().asyncExec(() -> this.sh.close());
        }
    }

    private static final class GrantFlow
    extends AbstractGrantFlow {
        private final AuthorizationCodeGrantBean codeBean;
        private final String authorizationCode;

        GrantFlow(AuthorizationCodeGrantBean codeBean, String authorizationCode) {
            super(new ResourceOwnerGrantBean());
            this.codeBean = codeBean;
            this.authorizationCode = authorizationCode;
            this.bean.tokenURI = codeBean.tokenURI;
            this.bean.additionalHeaders = codeBean.additionalHeaders;
            this.bean.enableCertificateVerification = codeBean.enableCertificateVerification;
            this.bean.enableHostnameVerification = codeBean.enableHostnameVerification;
            this.bean.httpMethod = "POST";
        }

        @Override
        protected Map<String, String> getAccessTokenEndpointQueryParam() throws Exception {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "authorization_code");
            params.put("redirect_uri", this.codeBean.redirectURI);
            params.put("code", this.authorizationCode);
            String[] clientIdAndSecrets = this.resolveSecrets(this.codeBean.clientId, this.codeBean.clientSecret);
            params.put("client_id", clientIdAndSecrets[0]);
            params.put("client_secret", clientIdAndSecrets[1]);
            return params;
        }
    }

    private class PortWarningDialog
    extends MessageDialog {
        public PortWarningDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button button = this.createButton(parent, 20, Messages.AuthorizationCodeGrantFlow_1, false);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfPreferencePage page = new ConfPreferencePage();
                    PreferenceManager mgr = new PreferenceManager();
                    PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                    mgr.addToRoot((IPreferenceNode)node);
                    PreferenceDialog dialog = new PreferenceDialog(PortWarningDialog.this.getShell(), mgr);
                    dialog.create();
                    dialog.setMessage(page.getTitle());
                    dialog.open();
                }
            });
        }
    }
}

