/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantBean;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantPage;
import com.indy.addons.oauth2.wizard.Linker;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantBean;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantPage;
import com.indy.addons.oauth2.wizard.ResourceOwnerLinker;
import com.indy.md.ui.editor.ui.MdWizard;
import com.stambia.md.MdNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class OAuth2Wizard
extends MdWizard {
    private ILinker mdLinker;

    public void setNode(MdNode node) {
        super.setNode(node);
        String s = node.getAttributeValueByShortCode("flowType");
        if (s == null || s.trim().isEmpty()) {
            this.mdLinker = new Linker(FlowType.AUTHORIZATION_CODE_GRANT);
        } else if (FlowType.AUTHORIZATION_CODE_GRANT.getValue().equals(s)) {
            this.mdLinker = new Linker(FlowType.AUTHORIZATION_CODE_GRANT);
        } else if (FlowType.CLIENT_CREDENTIALS_GRANT.getValue().equals(s)) {
            this.mdLinker = new ResourceOwnerLinker(FlowType.CLIENT_CREDENTIALS_GRANT);
        } else if (FlowType.IMPLICIT_GRANT.getValue().equals(s)) {
            this.mdLinker = new Linker(FlowType.IMPLICIT_GRANT);
        } else if (FlowType.RESOURCE_OWNER_PASSWORD_CREDENTIALS_CODE_GRANT.getValue().equals(s)) {
            this.mdLinker = new ResourceOwnerLinker(FlowType.RESOURCE_OWNER_PASSWORD_CREDENTIALS_CODE_GRANT);
        }
        this.mdLinker.setNode(node);
    }

    public void dispose() {
        this.mdLinker.dispose();
        super.dispose();
    }

    public void addPages() {
        Object bean = this.mdLinker.getBean();
        if (bean instanceof AuthorizationCodeGrantBean) {
            this.addPage((IWizardPage)new AuthorizationCodeGrantPage((Linker)this.mdLinker));
        } else if (bean instanceof ResourceOwnerGrantBean) {
            this.addPage((IWizardPage)new ResourceOwnerGrantPage((ResourceOwnerLinker)this.mdLinker));
        }
    }

    public boolean performFinish() {
        block3: {
            try {
                if (this.mdLinker.canFinish() || MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Messages.OAuth2Wizard_5, (String)Messages.OAuth2Wizard_6)) break block3;
                return false;
            }
            catch (Exception ex) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.OAuth2Wizard_7 + ex.getMessage(), (Throwable)ex), 3);
                return false;
            }
        }
        this.mdLinker.updateMdNode();
        return true;
    }

    public static enum FlowType {
        AUTHORIZATION_CODE_GRANT("Authorization Code Grant"),
        IMPLICIT_GRANT("Implicit Grant"),
        RESOURCE_OWNER_PASSWORD_CREDENTIALS_CODE_GRANT("Resource Owner Password Credentials Grant"),
        CLIENT_CREDENTIALS_GRANT("Client Credentials Grant");

        private String value;

        private FlowType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface ILinker {
        public void setNode(MdNode var1);

        public void dispose();

        public Object getBean();

        public boolean canFinish();

        public void updateMdNode() throws Exception;

        public FlowType getFlowType();
    }
}

