/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.avro.reader;

import com.indy.runtime.hierarchy.HierarchyEvent;
import com.indy.runtime.hierarchy.HierarchyEventReader;
import com.stambia.avro.reader.visitor.AvroVisitorHandler;
import com.stambia.avro.reader.visitor.AvroVisitorImplementation;
import com.stambia.avro.reader.visitor.AvroVisitorInterface;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;

public final class AvroToHierarchyEventReader
extends HierarchyEventReader {
    private DataFileStream<GenericRecord> dataFileStream;
    private final List<HierarchyEvent> avroEventList = new ArrayList<HierarchyEvent>();
    private final AvroVisitorInterface avroVisitor = new AvroVisitorImplementation(this.avroEventList);
    private int eventIndex = -1;
    private boolean readingFinished;
    Schema rootSchema;

    public AvroToHierarchyEventReader(InputStream inputStream) throws IOException {
        GenericDatumReader datumReader = new GenericDatumReader();
        this.dataFileStream = new DataFileStream((InputStream)new BufferedInputStream(inputStream), (DatumReader)datumReader);
    }

    public AvroToHierarchyEventReader() throws Exception {
    }

    public final HierarchyEvent nextHierarchyEvent() throws Exception {
        if (this.readingFinished) {
            return null;
        }
        if (this.eventIndex + 1 == this.avroEventList.size()) {
            boolean hasNextRecord;
            while ((hasNextRecord = this.nextRecord()) && this.avroEventList.size() == 0) {
            }
            if (!hasNextRecord) {
                this.readingFinished = true;
                return null;
            }
        }
        ++this.eventIndex;
        return this.avroEventList.get(this.eventIndex);
    }

    private final boolean nextRecord() throws Exception {
        if (this.dataFileStream != null) {
            if (this.dataFileStream.hasNext()) {
                this.eventIndex = -1;
                GenericRecord rootRecord = (GenericRecord)this.dataFileStream.next();
                this.visitRecord(rootRecord);
                return true;
            }
            return false;
        }
        return false;
    }

    public void visitRecord(GenericRecord rootRecord) throws Exception {
        this.avroEventList.clear();
        this.rootSchema = rootRecord.getSchema();
        AvroVisitorHandler.visit(rootRecord, this.rootSchema, this.avroVisitor);
    }

    public Schema getRootSchema() {
        return this.rootSchema;
    }

    public final void close() throws XMLStreamException {
        try {
            this.dataFileStream.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }
}

