/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.avro.reader.visitor;

import com.stambia.avro.reader.visitor.AvroVisitorInterface;
import com.stambia.avro.reader.visitor.AvroXMLConverter;
import com.stambia.avro.reader.visitor.Messages;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

public final class AvroVisitorHandler {
    private static final Set<Schema.Type> complexTypes = new HashSet<Schema.Type>();

    static {
        complexTypes.add(Schema.Type.RECORD);
        complexTypes.add(Schema.Type.MAP);
        complexTypes.add(Schema.Type.ARRAY);
        complexTypes.add(Schema.Type.UNION);
        complexTypes.add(Schema.Type.ENUM);
        complexTypes.add(Schema.Type.FIXED);
    }

    public static final void visit(Object node, Schema schema, AvroVisitorInterface avroVisitor) throws Exception {
        if (schema != null) {
            Schema.Type schemaType = schema.getType();
            if (schemaType == Schema.Type.RECORD) {
                String recordName = schema.getFullName();
                avroVisitor.visitStartRecord(recordName);
                GenericRecord record = (GenericRecord)node;
                List fields = schema.getFields();
                int fieldsSize = fields.size();
                int fieldIndex = 0;
                while (fieldIndex < fieldsSize) {
                    Schema.Field field = (Schema.Field)fields.get(fieldIndex);
                    String fieldName = field.name();
                    avroVisitor.visitStartField(fieldName);
                    Object fieldObject = record.get(fieldIndex);
                    Schema fieldSchema = field.schema();
                    AvroVisitorHandler.visit(fieldObject, fieldSchema, avroVisitor);
                    avroVisitor.visitEndField(fieldName);
                    ++fieldIndex;
                }
                avroVisitor.visitEndRecord(recordName);
            } else if (schemaType == Schema.Type.MAP) {
                avroVisitor.visitStartMap();
                Schema valueSchema = schema.getValueType();
                Schema.Type valueType = valueSchema.getType();
                boolean isComplexType = complexTypes.contains(valueType);
                Map map = (Map)node;
                for (Map.Entry entry : map.entrySet()) {
                    String key = ((Utf8)entry.getKey()).toString();
                    avroVisitor.visitStartKey(key);
                    Object value = entry.getValue();
                    if (isComplexType) {
                        AvroVisitorHandler.visit(value, valueSchema, avroVisitor);
                    } else {
                        avroVisitor.visitPrimitive(value, valueSchema);
                    }
                    avroVisitor.visitEndKey();
                }
                avroVisitor.visitEndMap();
            } else if (schemaType == Schema.Type.ARRAY) {
                avroVisitor.visitStartArray();
                Schema elementSchema = schema.getElementType();
                Schema.Type elementType = elementSchema.getType();
                boolean isComplexType = complexTypes.contains(elementType);
                GenericArray array = (GenericArray)node;
                int index = 0;
                for (Object element : array) {
                    avroVisitor.visitStartIndex(index++);
                    if (isComplexType) {
                        AvroVisitorHandler.visit(element, elementSchema, avroVisitor);
                    } else {
                        avroVisitor.visitPrimitive(element, elementSchema);
                    }
                    avroVisitor.visitEndIndex();
                }
                avroVisitor.visitEndArray();
            } else if (schemaType == Schema.Type.ENUM) {
                GenericData.EnumSymbol enumSymbol = (GenericData.EnumSymbol)node;
                avroVisitor.visitEnum(enumSymbol);
            } else if (schemaType == Schema.Type.FIXED) {
                GenericData.Fixed fixed = (GenericData.Fixed)node;
                avroVisitor.visitFixed(fixed);
            } else if (schemaType == Schema.Type.UNION) {
                if (node != null) {
                    Schema usedSchema = AvroVisitorHandler.findUsedUnionSchema(schema, node);
                    AvroVisitorHandler.visit(node, usedSchema, avroVisitor);
                } else {
                    AvroVisitorHandler.visit(null, null, avroVisitor);
                }
            } else {
                avroVisitor.visitPrimitive(node, schema);
            }
        } else {
            avroVisitor.visitPrimitive(node, null);
        }
    }

    public static Schema findSchemaByType(List<Schema> schema, Schema.Type type) {
        for (Schema candidateSchema : schema) {
            Schema.Type candidateType = candidateSchema.getType();
            if (candidateType != type) continue;
            return candidateSchema;
        }
        throw new RuntimeException(Messages.getString("AvroVisitorHandler.1") + String.valueOf(type) + Messages.getString("AvroVisitorHandler.2") + String.valueOf(schema));
    }

    public static Schema findSchemaByName(List<Schema> schema, String name) {
        for (Schema candidateSchema : schema) {
            String candidateType = candidateSchema.getFullName();
            if (candidateType == null || !candidateType.equals(name)) continue;
            return candidateSchema;
        }
        throw new RuntimeException(Messages.getString("AvroVisitorHandler.3") + name + Messages.getString("AvroVisitorHandler.4") + String.valueOf(schema));
    }

    static final Schema findUsedUnionSchemaBak(Schema unionSchema, Object node) {
        Schema usedSchema = null;
        if (node instanceof GenericData.Array) {
            GenericData.Array array = (GenericData.Array)node;
            usedSchema = array.getSchema();
        } else if (node instanceof Map) {
            List unionSchemas = unionSchema.getTypes();
            for (Schema candidateSchema : unionSchemas) {
                Schema.Type candidateType = candidateSchema.getType();
                if (candidateType != Schema.Type.MAP) continue;
                usedSchema = candidateSchema;
                break;
            }
            if (usedSchema == null) {
                throw new RuntimeException(Messages.getString("AvroVisitorHandler.5"));
            }
        } else if (node instanceof GenericRecord) {
            GenericRecord genericRecord = (GenericRecord)node;
            usedSchema = genericRecord.getSchema();
        } else if (node instanceof GenericData.Fixed) {
            GenericData.Fixed fixed = (GenericData.Fixed)node;
            usedSchema = fixed.getSchema();
        } else if (node instanceof GenericData.EnumSymbol) {
            GenericData.EnumSymbol enumSymbol = (GenericData.EnumSymbol)node;
            usedSchema = enumSymbol.getSchema();
        }
        return usedSchema;
    }

    public static Schema getSchema(Object node) {
        if (node instanceof GenericContainer) {
            return ((GenericContainer)node).getSchema();
        }
        return null;
    }

    public static final Schema findUsedUnionSchema(Schema unionSchema, Object node) {
        Schema schema = AvroVisitorHandler.getSchema(node);
        if (schema == null) {
            AvroXMLConverter.InternalType type = AvroXMLConverter.INSTANCE.getInternalType(node);
            return AvroVisitorHandler.findSchemaByType(unionSchema.getTypes(), type.getRealType());
        }
        return schema;
    }
}

