/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.avro.reader.visitor;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;

public final class FormatHandler {
    private static final DateTimeFormatter ZONED = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final DateTimeFormatter LOCAL = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private static final DateTimeFormatter TIME_MILLIS = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final DateTimeFormatter TIME_MICROS = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS");
    private static final DateTimeFormatter TIMESTAMP_MICROS = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
    private static final DateTimeFormatter TIMESTAMP_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");

    private FormatHandler() {
    }

    public static String timestampMillis(long epochMillis) {
        return DatatypeConverter.printDateTime((Calendar)FormatHandler.toCalendar(epochMillis));
    }

    public static String timestampMicros(long epochMicros) {
        Instant instant = Instant.ofEpochSecond(epochMicros / 1000000L, (int)TimeUnit.MICROSECONDS.toNanos(epochMicros % 1000000L));
        LocalDateTime utcDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(utcDateTime, FormatHandler.currentOffset());
        return ZONED.format(offsetDateTime);
    }

    public static String localTimestampMillis(long epochMillis) {
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(epochMillis / 1000L, (int)TimeUnit.MILLISECONDS.toNanos(epochMillis % 1000L), ZoneOffset.UTC);
        return TIMESTAMP_MILLIS.format(ldt);
    }

    public static String localTimestampMicros(long epochMicros) {
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(epochMicros / 1000000L, (int)TimeUnit.MICROSECONDS.toNanos(epochMicros % 1000000L), ZoneOffset.UTC);
        return TIMESTAMP_MICROS.format(ldt);
    }

    public static String timeMillis(int millis) {
        Calendar calendar = Calendar.getInstance();
        int ms = millis % 1000;
        int seconds = millis / 1000 % 60;
        int minutes = millis / 60000 % 60;
        int hours = millis / 3600000 % 24;
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, ms);
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    public static String timeMicros(long micros) {
        LocalTime lt = LocalTime.ofNanoOfDay(micros * 1000L);
        return TIME_MICROS.format(lt);
    }

    public static String dateFromEpochDays(int days) {
        Calendar cal = FormatHandler.toCalendar((long)days * 86400000L);
        return DatatypeConverter.printDate((Calendar)cal);
    }

    public static long toTimestampMillis(String xmlDateTime) {
        Calendar cal = DatatypeConverter.parseDateTime((String)xmlDateTime);
        return cal.getTimeInMillis();
    }

    public static long toTimestampMicros(String xmlDateTime) {
        try {
            return ChronoUnit.MICROS.between(Instant.EPOCH, OffsetDateTime.parse(xmlDateTime, ZONED).toInstant());
        }
        catch (DateTimeParseException e) {
            LocalDateTime localDateTime = LocalDateTime.parse(xmlDateTime, LOCAL);
            return ChronoUnit.MICROS.between(Instant.EPOCH, localDateTime.toInstant(ZoneOffset.UTC));
        }
    }

    public static long toLocalTimestampMillis(String xmlDateTime) {
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(xmlDateTime, LOCAL);
            return localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            LocalDateTime localDateTime = LocalDateTime.parse(xmlDateTime, ZONED);
            return localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        }
    }

    public static long toLocalTimestampMicros(String xmlDateTime) {
        LocalDateTime ldt;
        try {
            ldt = LocalDateTime.parse(xmlDateTime, LOCAL);
        }
        catch (DateTimeParseException e) {
            ldt = LocalDateTime.parse(xmlDateTime, ZONED);
        }
        long seconds = ldt.toEpochSecond(ZoneOffset.UTC);
        int micros = ldt.getNano() / 1000;
        return seconds * 1000000L + (long)micros;
    }

    public static int toTimeMillis(String time) {
        Calendar calendar = DatatypeConverter.parseTime((String)time);
        long now = calendar.getTimeInMillis();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long passed = now - calendar.getTimeInMillis();
        return (int)passed;
    }

    public static long toTimeMicros(String time) {
        List<DateTimeFormatter> formatters = List.of(DateTimeFormatter.ofPattern("HH:mm:ss[.SSSSSS]"), LOCAL, ZONED);
        for (DateTimeFormatter formatter : formatters) {
            try {
                LocalTime lt = LocalTime.parse(time, formatter);
                return lt.toNanoOfDay() / 1000L;
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        throw new RuntimeException("Unable to parse datetime: " + time);
    }

    public static int toEpochDays(String xmlDate) {
        Calendar cal = DatatypeConverter.parseDate((String)xmlDate);
        return (int)(cal.getTimeInMillis() / 86400000L);
    }

    private static Calendar toCalendar(long epochMillis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(epochMillis);
        return cal;
    }

    private static ZoneOffset currentOffset() {
        return ZoneId.systemDefault().getRules().getOffset(Instant.now());
    }
}

