/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.service.bus;

import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClientBuilder;
import com.indy.engine.action.common.ActionCodeTypeI;
import com.semarchy.xdi.component.azure.service.bus.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;

public abstract class AzureServiceBusActionCode
extends ActionCodeTypeI {
    protected AzureServiceBusActionCode(String actionCodeName, boolean bNullCodeAllowed) {
        super(actionCodeName, bNullCodeAllowed);
    }

    protected void setCredentials(ConnectionStringTrait<?> builder) throws EngineExceptionI {
        boolean useDefaultCredentials = this.getLocalBooleanParameter("USE_DEFAULT_CREDENTIALS", false);
        if (useDefaultCredentials) {
            DefaultAzureCredential credentials = new DefaultAzureCredentialBuilder().build();
            String namespaceName = this.getLocalStringParameter("NAMESPACE_NAME", "");
            if (namespaceName == null || namespaceName.isEmpty()) {
                throw new EngineExceptionI(Messages.getString("AzureServiceBusActionCode.6"));
            }
            this.setCredentials(builder, namespaceName + ".servicebus.windows.net", (TokenCredential)credentials);
        } else {
            String connString = this.decryptString(this.getLocalStringParameter("CONNECTION_STRING", ""));
            if (connString == null || connString.isEmpty()) {
                throw new EngineExceptionI(Messages.getString("AzureServiceBusActionCode.5"));
            }
            builder.connectionString(connString);
        }
    }

    private void setCredentials(Object builder, String namespace, TokenCredential credential) {
        if (builder instanceof ServiceBusAdministrationClientBuilder) {
            ((ServiceBusAdministrationClientBuilder)builder).credential(namespace, credential);
        } else if (builder instanceof ServiceBusClientBuilder) {
            ((ServiceBusClientBuilder)builder).credential(namespace, credential);
        }
    }
}

