/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.service.bus;

import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.semarchy.xdi.component.azure.service.bus.AzureServiceBusActionCode;
import com.semarchy.xdi.component.azure.service.bus.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;

public abstract class AzureServiceBusSenderActionCode
extends AzureServiceBusActionCode {
    protected ServiceBusSenderClient client;
    private int messageCount = 0;
    private boolean scheduleMessage;
    private String scheduleTime;
    private int scheduleDelay;

    protected AzureServiceBusSenderActionCode(String actionCodeName, boolean bNullCodeAllowed) {
        super(actionCodeName, bNullCodeAllowed);
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        this.scheduleMessage = this.getLocalBooleanParameter("SCHEDULE_MESSAGE", false);
        this.scheduleDelay = this.getLocalIntegerParameter("SCHEDULE_DELAY", 0);
        this.scheduleTime = this.getLocalStringParameter("SCHEDULE_TIME", "");
        return 0;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws Exception {
        String messageBody = this.getFinalBindedCode(sourceRSet, this.actionTxtCode);
        this.sendMessage(messageBody);
        return 0;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        this.sendMessage(this.actionTxtCode);
        return 0;
    }

    public void sendMessage(String messageBody) throws EngineExceptionI {
        ServiceBusMessage message = new ServiceBusMessage(messageBody);
        if (this.scheduleMessage) {
            OffsetDateTime enqueueTime;
            if (this.scheduleTime != null && !this.scheduleTime.isEmpty()) {
                enqueueTime = this.parseDate(this.scheduleTime);
            } else if (this.scheduleDelay > 0) {
                enqueueTime = OffsetDateTime.now().plusSeconds(this.scheduleDelay);
            } else {
                throw new EngineExceptionI(Messages.getString("AzureServiceBusSenderActionCode.0"));
            }
            message.setScheduledEnqueueTime(enqueueTime);
        }
        this.client.sendMessage(message);
        ++this.messageCount;
        this.publishStatistic("AZURE_SERVICE_BUS_SENT_MESSAGES", this.messageCount, false);
    }

    private OffsetDateTime parseDate(String dateTimeString) throws EngineExceptionI {
        OffsetDateTime parsedDate = null;
        try {
            parsedDate = OffsetDateTime.parse(dateTimeString);
        }
        catch (DateTimeParseException e) {
            try {
                LocalDateTime local = LocalDateTime.parse(dateTimeString);
                parsedDate = local.atOffset(ZoneOffset.UTC);
            }
            catch (DateTimeParseException e2) {
                throw new EngineExceptionI(Messages.getString("AzureServiceBusSenderActionCode.1"));
            }
        }
        return parsedDate;
    }

    public int finalizeSimpleExecuteCode() throws EngineExceptionI {
        this.publishStatistic("AZURE_SERVICE_BUS_SENT_MESSAGES", this.messageCount, true);
        this.client.close();
        return super.finalizeSimpleExecuteCode();
    }
}

