/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.service.bus;

import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import java.time.ZoneOffset;

public enum MessageColumn {
    MESSAGE_CONTENT(1, 12),
    CREATION_TIME(2, 93),
    MESSAGE_ID(3, 12),
    SEQUENCE_NUMBER(4, -5);

    private int index;
    private int sqlType;

    private MessageColumn(int index, int sqlType) {
        this.index = index;
        this.sqlType = sqlType;
    }

    public int index() {
        return this.index;
    }

    public int sqlType() {
        return this.sqlType;
    }

    public Object getValueFromMessage(ServiceBusReceivedMessage message) {
        switch (this) {
            case MESSAGE_CONTENT: {
                return message.getBody().toString();
            }
            case CREATION_TIME: {
                return message.getEnqueuedTime().withOffsetSameInstant(ZoneOffset.UTC).toLocalDateTime();
            }
            case MESSAGE_ID: {
                return message.getMessageId();
            }
            case SEQUENCE_NUMBER: {
                return message.getSequenceNumber();
            }
        }
        return null;
    }
}

