/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.salesforce;

import com.indy.engine.addons.salesforce.SForceBaseActionCodeI;
import com.indy.runtime.file.DelimitedFileWriter;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.sforce.soap.partner.fault.ApiFault;
import com.stambia.salesforce.connector.SalesForceBulkConnection;
import com.stambia.salesforce.connector.util.SFQueryToFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

public class SForceToFileActionCodeI
extends SForceBaseActionCodeI {
    private String outDirectory;
    private String patternOutFile;
    private int zipMode;
    private int fileBufferSize = 8192;
    String encoding = "UTF-8";
    String stringDelimiter = "\"";
    String stringDelimiterReplacment = "\"\"";
    String rowSeparator = "\n";
    String rowSeparatorReplacment = null;
    String fieldSeparator = ",";
    String dateFormat = "yyyy/MM/dd";
    String dateTimeFormat = "yyyy/MM/dd HH:mm:ss.SSS";
    String timeFormat = "HH:mm:ss.SSS";
    private static final int ZIP_MODE_NONE = 0;
    private static final int ZIP_MODE_GZIP = 1;

    @Override
    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        super.prepare(sourceRSet);
        this.parseQueries();
        this.outDirectory = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_DIR");
        this.patternOutFile = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_PATTERN");
        this.encoding = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_ENCODING", "UTF-8");
        this.stringDelimiter = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_STRING_DELIMITER", "\"");
        this.stringDelimiterReplacment = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_STRING_DELIMITER_REPLACEMENT", "auto");
        if (this.stringDelimiterReplacment.equals("auto")) {
            this.stringDelimiterReplacment = this.stringDelimiter + this.stringDelimiter;
        }
        this.rowSeparator = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_ROW_SEPARATOR", "\n");
        this.rowSeparator = this.rowSeparator.replace("\\n", "\n");
        this.rowSeparator = this.rowSeparator.replace("\\t", "\t");
        this.rowSeparator = this.rowSeparator.replace("\\r", "\r");
        this.rowSeparatorReplacment = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_ROW_SEPARATOR_REPLACEMENT", null);
        this.fieldSeparator = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_FIELD_SEPARATOR");
        this.fieldSeparator = this.fieldSeparator.replace("\\n", "\n");
        this.fieldSeparator = this.fieldSeparator.replace("\\t", "\t");
        this.fieldSeparator = this.fieldSeparator.replace("\\r", "\r");
        this.dateFormat = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_DATE_FORMAT", "yyyy/MM/dd");
        this.dateTimeFormat = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_DATE_TIME_FORMAT", "yyyy/MM/dd HH:mm:ss.SSS");
        this.timeFormat = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_TIME_FORMAT", "HH:mm:ss.SSS");
        try {
            String currentZipMode = this.getLocalStringBindedParameter(sourceRSet, "SFORCE_FILE_ZIP_MODE", "disable");
            this.zipMode = currentZipMode.equalsIgnoreCase("gzip") ? 1 : 0;
        }
        catch (EngineExceptionI e) {
            this.zipMode = 0;
        }
        return 0;
    }

    @Override
    public int executeSimpleCode() throws EngineExceptionI {
        block35: {
            Throwable throwable = null;
            Object var2_5 = null;
            SalesForceBulkConnection con = this.connect();
            try {
                SFQueryToFile sfQueryToFile = new SFQueryToFile(con);
                int[] dataNb = new int[1];
                sfQueryToFile.setHandler(nbRecord -> {
                    nArray[0] = dataNb[0] + nbRecord;
                    this.publishVariable("SFORCE_NB_SELECT", dataNb[0], "Long");
                });
                sfQueryToFile.startDocument();
                int i = 1;
                for (String sObject : this.sObjectList) {
                    File file = new File(this.outDirectory, SForceToFileActionCodeI.getFileName(sObject, this.patternOutFile));
                    SForceBaseActionCodeI.QueryInf query = this.quetQuery(sObject);
                    this.publishVariable("SFORCE_QUERY_NB", i++, "Integer");
                    this.publishVariable("SFORCE_LAST_QUERY", query, "String");
                    Throwable throwable2 = null;
                    Object var12_17 = null;
                    try {
                        FileOutputStream os1 = new FileOutputStream(file);
                        try {
                            try (FilterOutputStream os2 = this.zipMode == 1 ? new GZIPOutputStream((OutputStream)os1, this.fileBufferSize) : new BufferedOutputStream(os1, this.fileBufferSize);
                                 DelimitedFileWriter writer = null;){
                                writer = new DelimitedFileWriter((OutputStream)os2);
                                writer.setEncoding(this.encoding);
                                writer.setFieldSeparator(this.fieldSeparator);
                                writer.setRowSeparator(this.rowSeparator, this.rowSeparatorReplacment);
                                writer.setStringDelimiter(this.stringDelimiter, this.stringDelimiterReplacment);
                                Map<String, String> map = query.getXmlTypes();
                                for (String name : query.getSortedFieldNames()) {
                                    sfQueryToFile.addSortedFieldName(name);
                                    sfQueryToFile.addXmlType(name, map.get(name));
                                }
                                sfQueryToFile.dump(query.query, query.sObjectType, writer, query.getDeletedData, query.deletetionStartDate, query.deletetionEndDate, query.offsetUnit, query.offset);
                            }
                            if (os1 == null) continue;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (os1 != null) {
                                ((OutputStream)os1).close();
                            }
                            throw throwable2;
                        }
                        ((OutputStream)os1).close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
                sfQueryToFile.endDocument();
                if (con == null) break block35;
            }
            catch (Throwable throwable5) {
                try {
                    try {
                        if (con != null) {
                            con.close();
                        }
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (ApiFault e) {
                    throw new EngineExceptionI(e.getExceptionMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            con.close();
        }
        return 0;
    }

    private static String getFileName(String sObjectName, String fileMask) {
        Pattern pattern = Pattern.compile("(\\[[A-Za-z0-9]+\\])");
        Matcher matcher = pattern.matcher(fileMask);
        int last = 0;
        Object ret = "";
        while (matcher.find()) {
            String word = matcher.group(1);
            if (word == null) continue;
            if (matcher.start(1) > last) {
                ret = (String)ret + fileMask.substring(last, matcher.start(1));
            }
            if (word.equalsIgnoreCase("[SOBJECTNAME]")) {
                ret = (String)ret + sObjectName;
            }
            last = matcher.end(1);
        }
        if (last < fileMask.length()) {
            ret = (String)ret + fileMask.substring(last);
        }
        return ret;
    }

    @Override
    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }
}

