/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.salesforce;

import com.indy.engine.addons.salesforce.CommonXmlToSF;
import com.indy.engine.addons.salesforce.Messages;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.salesforce.bulk.configuration.SfBulkConfiguration;
import com.stambia.salesforce.connector.util.XmlToSForceBulkV2;
import endolabs.salesforce.bulkv2.type.OperationEnum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XmlToSForceBulkV2ActionCodeI
extends CommonXmlToSF {
    private static final String WORK_FOLDER = "SF_WORK_FOLDER";
    private static final String FILE_PATTERN = "SF_FILE_PATTERN";
    private static final String FLOW_TYPE = "Resource Owner Password Credentials Grant";
    XmlToSForceBulkV2 xmlToSForceBulkV2;

    @Override
    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        super.prepare(sourceRSet);
        this.bulkMaxConcurrentBatch = this.getLocalIntegerBindedParameter(sourceRSet, "SF_BULK_MAX_CONCURRENT_BATCHES", -1);
        OperationEnum operation = OperationEnum.fromValue(this.rawIntegrationMode);
        String filePattern = this.getLocalStringBindedParameter(sourceRSet, FILE_PATTERN, "").trim();
        XMLEventReader reader = null;
        Path defaultFolderPath = null;
        try {
            try {
                defaultFolderPath = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]);
                String folderPath = this.getLocalStringBindedParameter(sourceRSet, WORK_FOLDER, defaultFolderPath.toString()).trim();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setProperty("javax.xml.stream.supportDTD", false);
                inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                Throwable throwable = null;
                Object var9_11 = null;
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(this.inputXmlContent.getBytes());){
                    reader = inputFactory.createXMLEventReader(inputStream, "UTF-8");
                    String sfObjectName = null;
                    ArrayList<String> fieldsNames = new ArrayList<String>();
                    HashSet<String> externalIdFieldNames = new HashSet<String>();
                    block22: while (reader.hasNext()) {
                        StartElement startElement;
                        String localName;
                        XMLEvent event = reader.nextEvent();
                        if (!event.isStartElement() || (localName = (startElement = event.asStartElement()).getName().getLocalPart()) == null) continue;
                        Attribute attribute = startElement.getAttributeByName(Q_NAME);
                        String name = attribute != null ? attribute.getValue() : null;
                        switch (localName) {
                            case "sObject": {
                                sfObjectName = name;
                                if (filePattern != null && !filePattern.isEmpty()) continue block22;
                                filePattern = name;
                                break;
                            }
                            case "field": {
                                boolean isExternalId;
                                fieldsNames.add(name);
                                attribute = startElement.getAttributeByName(Q_IS_EXTERNAL_ID);
                                boolean bl = isExternalId = attribute != null ? Boolean.valueOf(attribute.getValue()) : false;
                                if (!isExternalId) break;
                                externalIdFieldNames.add(name);
                                break;
                            }
                        }
                    }
                    if (this.otmd == null) {
                        throw new EngineExceptionI(Messages.getString("SForceBaseActionCodeI.6"));
                    }
                    this.otmd.login = this.login;
                    this.otmd.password = this.password;
                    this.otmd.clientCredentialPolicy = OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET;
                    this.otmd.flowType = FLOW_TYPE;
                    SfBulkConfiguration.SalesforceParameter salesforceParameter = new SfBulkConfiguration.SalesforceParameter(this.authenticationEndPoint, operation, sfObjectName, fieldsNames, externalIdFieldNames, this.sForceBulkAwaitPolling.intValue(), this.sForceBatchSize, this.errorAcceptance, this.bulkMaxConcurrentBatch, this.sForceReadTimeout, this.sForceConnectionTimeout);
                    this.xmlToSForceBulkV2 = new XmlToSForceBulkV2(this.otmd, salesforceParameter, folderPath, filePattern, this.getLogger(), this.inFile);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    this.logger.warn("unexpected", (Throwable)e);
                }
            }
            if (defaultFolderPath != null) {
                this.deleteDirectory(defaultFolderPath.toFile());
            }
        }
        return 0;
    }

    private void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            File[] fileArray = allContents;
            int n = allContents.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.deleteDirectory(file);
                ++n2;
            }
        }
        try {
            Files.delete(directoryToBeDeleted.toPath());
        }
        catch (IOException e) {
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int executeSimpleCode() throws EngineExceptionI {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.inFile));
                try {
                    try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.outFile));){
                        this.xmlToSForceBulkV2.readWrite(is, os);
                    }
                    if (is == null) return 0;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    ((InputStream)is).close();
                    throw throwable;
                }
                ((InputStream)is).close();
                return 0;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.logger.warn("unexpected", (Throwable)e);
            throw new EngineExceptionI((Throwable)e);
        }
    }
}

