/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.bulk.configuration;

import com.indy.engine.addons.salesforce.SForceErrorAcceptance;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import endolabs.salesforce.bulkv2.type.OperationEnum;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class SfBulkConfiguration {
    private final OAuth2Metadata oAuth2Parameter;
    private final SalesforceParameter salesforceParameter;
    private final WorkingFolder workingFolder;
    private final Logger logger;

    public SfBulkConfiguration(OAuth2Metadata oAuth2Metadata, SalesforceParameter sfObject, WorkingFolder workingFolder, Logger logger) {
        this.oAuth2Parameter = oAuth2Metadata;
        this.salesforceParameter = sfObject;
        this.workingFolder = workingFolder;
        this.logger = logger;
    }

    public final OAuth2Metadata getOAuth2Parameter() {
        return this.oAuth2Parameter;
    }

    public final SalesforceParameter getSalesforceParameter() {
        return this.salesforceParameter;
    }

    public final WorkingFolder getWorkingFolder() {
        return this.workingFolder;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static final class SalesforceParameter {
        private final String endpoint;
        private final OperationEnum operation;
        private final String name;
        private final List<String> fieldsNames;
        private final Set<String> externalIdFieldNames;
        private final int pollInterval;
        private final int jobMaximumSize;
        private SForceErrorAcceptance errorAcceptance;
        private int bulkMaxConcurrentBatch;
        private final Integer readTimeout;
        private final Integer connectionTimeout;

        public SalesforceParameter(String endpoint, OperationEnum operation, String name, List<String> fieldsNames, Set<String> externalIdFieldNames, int pollInterval, int jobMaximumSize) {
            this(endpoint, operation, name, fieldsNames, externalIdFieldNames, pollInterval, jobMaximumSize, new SForceErrorAcceptance(0), -1, null, null);
        }

        public SalesforceParameter(String endpoint, OperationEnum operation, String name, List<String> fieldsNames, Set<String> externalIdFieldNames, int pollInterval, int jobMaximumSize, SForceErrorAcceptance errorAcceptance, int bulkMaxConcurrentBatch, Integer readTimeout, Integer connectionTimeout) {
            this.endpoint = endpoint;
            this.operation = operation;
            this.name = name;
            this.fieldsNames = fieldsNames;
            this.externalIdFieldNames = externalIdFieldNames;
            this.pollInterval = pollInterval;
            this.jobMaximumSize = jobMaximumSize;
            this.errorAcceptance = errorAcceptance;
            this.bulkMaxConcurrentBatch = bulkMaxConcurrentBatch;
            this.readTimeout = readTimeout;
            this.connectionTimeout = connectionTimeout;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final OperationEnum getOperation() {
            return this.operation;
        }

        public final String getName() {
            return this.name;
        }

        public final List<String> getFieldsNames() {
            return this.fieldsNames;
        }

        public final Set<String> getExternalIdFieldNames() {
            return this.externalIdFieldNames;
        }

        public final int getPollInterval() {
            return this.pollInterval;
        }

        public final int getJobMaximumSize() {
            return this.jobMaximumSize;
        }

        public SForceErrorAcceptance getErrorAcceptance() {
            return this.errorAcceptance;
        }

        public int getBulkMaxConcurrentBatch() {
            return this.bulkMaxConcurrentBatch;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public Integer getConnectionTimeout() {
            return this.connectionTimeout;
        }
    }

    public static final class WorkingFolder {
        private final String folderPath;
        private final String fileNamePattern;

        public WorkingFolder(String folderPath, String fileNamePattern) {
            this.folderPath = folderPath;
            this.fileNamePattern = fileNamePattern;
        }

        public final String getFolderPath() {
            return this.folderPath;
        }

        public final String getFileNamePattern() {
            return this.fileNamePattern;
        }
    }
}

