/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.bulk.csvwriter;

import java.io.OutputStream;
import java.util.List;

public final class CsvJobWriter {
    private final OutputStream csvStream;
    private boolean firstLine = true;

    public CsvJobWriter(OutputStream out) {
        this.csvStream = out;
    }

    public final void addRow(List<String> columns) throws Exception {
        if (this.firstLine) {
            this.firstLine = false;
        } else {
            this.csvStream.write("\n".getBytes("UTF-8"));
        }
        boolean first = true;
        for (String column : columns) {
            if (first) {
                this.addTopLeftColumn(column);
                first = false;
                continue;
            }
            this.addRightColumn(column);
        }
    }

    private final void addRightColumn(String value) throws Exception {
        this.csvStream.write(",".getBytes("UTF-8"));
        this.addTopLeftColumn(value);
    }

    private final void addTopLeftColumn(String value) throws Exception {
        this.csvStream.write("\"".getBytes("UTF-8"));
        if (value != null) {
            this.csvStream.write(value.replace("\"", "\"\"").getBytes("UTF-8"));
        }
        this.csvStream.write("\"".getBytes("UTF-8"));
    }
}

