/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector;

import com.indy.addons.salesforce.core.ISalesForceConnection;
import com.indy.addons.salesforce.core.SFEntity;
import com.indy.addons.salesforce.core.SFField;
import com.indy.addons.salesforce.core.SFMetaData;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.GetDeletedResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.PicklistEntry;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.bind.XmlObject;
import com.stambia.salesforce.connector.IResultSet;
import com.stambia.salesforce.connector.IResultSetMetadata;
import com.stambia.salesforce.connector.Messages;
import com.stambia.salesforce.connector.SalesForceBulkConnection;
import com.stambia.salesforce.connector.exceptions.EntityProcessingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SalesForceConnection
implements ISalesForceConnection {
    public static final String END_POINT_AUTHENTICATION = "https://login.salesforce.com/services/Soap/u/26.0";
    public static final String END_POINT_VERSION = "/services/Soap/u/";
    private static final Logger LOGGER = Logger.getLogger(SalesForceConnection.class.getName());
    private String authenticationEndPoint = null;
    private String login;
    private String password;
    private String securityToken;
    private ConnectorConfig partnerConfig;
    private PartnerConnection partnerConnection;
    private SFMetaData metaData;
    private String proxyHost;
    private Integer readTimeout;
    private String serviceEndpoint;
    private int proxyPort = 8080;
    private String proxyUsername;
    private String proxyPassword;
    private Integer connectionTimeout;
    private String sessionId;
    static Map<String, Integer> count = new HashMap<String, Integer>();
    private boolean disableLogout;

    public void setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public void setSessionId(String accessToken) {
        this.sessionId = accessToken;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public SalesForceConnection(String login, String password, String securityToken, String authenticationEndPoint) throws Exception {
        SalesForceBulkConnection.getAuthEndPoint();
        this.login = login;
        this.password = password;
        this.securityToken = securityToken;
        this.authenticationEndPoint = authenticationEndPoint + END_POINT_VERSION + SalesForceBulkConnection.getAuthEndPoint();
    }

    protected final ConnectorConfig getPartnerConfig() {
        return this.partnerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login() throws Exception {
        Map<String, Integer> map = count;
        synchronized (map) {
            if (this.partnerConnection != null) {
                throw new IOException("Already logged in.");
            }
            try {
                this.partnerConfig = new ConnectorConfig();
                this.partnerConfig.setUsername(this.login);
                if (this.securityToken != null) {
                    this.partnerConfig.setPassword(this.password + this.securityToken);
                } else {
                    this.partnerConfig.setPassword(this.password);
                }
                if (this.proxyHost != null) {
                    this.partnerConfig.setProxy(this.proxyHost, this.proxyPort);
                }
                if (this.proxyUsername != null) {
                    this.partnerConfig.setProxyUsername(this.proxyUsername);
                }
                if (this.proxyPassword != null) {
                    this.partnerConfig.setProxyPassword(this.proxyPassword);
                }
                if (this.connectionTimeout != null) {
                    this.partnerConfig.setConnectionTimeout(this.connectionTimeout.intValue());
                }
                if (this.readTimeout != null) {
                    this.partnerConfig.setReadTimeout(this.readTimeout.intValue());
                }
                if (this.sessionId != null) {
                    this.partnerConfig.setSessionId(this.sessionId);
                }
                if (this.serviceEndpoint != null) {
                    this.partnerConfig.setServiceEndpoint(this.serviceEndpoint + END_POINT_VERSION + SalesForceBulkConnection.getAuthEndPoint());
                }
                this.partnerConfig.setAuthEndpoint(this.authenticationEndPoint);
                this.partnerConnection = new PartnerConnection(this.partnerConfig);
                this.metaData = new SFMetaData((ISalesForceConnection)this);
                Integer in = count.get(this.partnerConfig.getSessionId());
                if (in == null) {
                    count.put(this.partnerConfig.getSessionId(), 1);
                } else {
                    in = in + 1;
                    count.put(this.partnerConfig.getSessionId(), in);
                }
            }
            catch (Exception e) {
                throw new Exception(Messages.getString("SalesForceConnection.0") + this.authenticationEndPoint + Messages.getString("SalesForceConnection.1") + this.login + Messages.getString("SalesForceConnection.2") + this.securityToken, e);
            }
        }
    }

    public SFMetaData getMetaData() throws Exception {
        this.getPartnerConnection();
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws Exception {
        if (this.partnerConnection == null) {
            throw new Exception(Messages.getString("SalesForceConnection.3"));
        }
        Map<String, Integer> map = count;
        synchronized (map) {
            Integer in = count.get(this.partnerConfig.getSessionId());
            boolean logout = false;
            if (in == null) {
                logout = true;
            } else if ((in = Integer.valueOf(in - 1)) == 0) {
                logout = true;
                count.remove(this.partnerConfig.getSessionId());
            } else {
                count.put(this.partnerConfig.getSessionId(), in);
            }
            if (logout) {
                if (!this.disableLogout) {
                    this.partnerConnection.logout();
                }
                this.partnerConnection = null;
            }
        }
        if (this.metaData != null) {
            this.metaData.dispose();
            this.metaData = null;
        }
    }

    public PartnerConnection getPartnerConnection() throws Exception {
        if (this.partnerConnection == null) {
            throw new Exception(Messages.getString("SalesForceConnection.4"));
        }
        return this.partnerConnection;
    }

    public List<SFEntity> listAvailableObjects(boolean onlyQueryable) throws Exception {
        ArrayList<SFEntity> res = new ArrayList<SFEntity>();
        DescribeGlobalResult dgr = this.getPartnerConnection().describeGlobal();
        DescribeGlobalSObjectResult[] describeGlobalSObjectResultArray = dgr.getSobjects();
        int n = describeGlobalSObjectResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            DescribeGlobalSObjectResult dgor = describeGlobalSObjectResultArray[n2];
            if (!(dgor.getDeprecatedAndHidden() || onlyQueryable && !dgor.getQueryable())) {
                res.add(this.createSFEntity(dgor));
            }
            ++n2;
        }
        return res;
    }

    public List<SFField> loadEntityFields(String entityName) throws Exception {
        ArrayList<SFField> fields = new ArrayList<SFField>();
        DescribeSObjectResult[] dsrArray = this.getPartnerConnection().describeSObjects(new String[]{entityName});
        DescribeSObjectResult dsr = dsrArray[0];
        Field[] fieldArray = dsr.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!f.getDeprecatedAndHidden()) {
                fields.add(this.createSFField(f));
            }
            ++n2;
        }
        return fields;
    }

    public SaveResult[] update(String entityName, List<SObject> toUpdate) throws ConnectionException, Exception {
        SaveResult[] res = this.getPartnerConnection().update(toUpdate.toArray(new SObject[toUpdate.size()]));
        return res;
    }

    public UpsertResult[] upsert(String entityName, String externalIDFieldName, List<SObject> toUpsert) throws EntityProcessingException, Exception {
        UpsertResult[] res = this.getPartnerConnection().upsert(externalIDFieldName, toUpsert.toArray(new SObject[toUpsert.size()]));
        return res;
    }

    public SaveResult[] insert(String entityName, List<SObject> toCreate) throws ConnectionException, Exception {
        SaveResult[] res = this.getPartnerConnection().create(toCreate.toArray(new SObject[toCreate.size()]));
        return res;
    }

    public DeleteResult[] delete(String entityName, List<SObject> _toDelete) throws EntityProcessingException, Exception {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (SObject so : _toDelete) {
            if (so.getId() != null) {
                toDelete.add(so.getId());
                continue;
            }
            throw new Exception(Messages.getString("SalesForceConnection.5") + so.toString());
        }
        DeleteResult[] res = this.getPartnerConnection().delete(toDelete.toArray(new String[toDelete.size()]));
        return res;
    }

    public IResultSet executeQuery(String query) throws Exception {
        QueryResult qr = this.getPartnerConnection().query(query);
        return new ResultSet(qr);
    }

    public HashMap<String, List<SFField>> loadEntityFields(List<String> toLoad) throws Exception {
        HashMap<String, List<SFField>> map = new HashMap<String, List<SFField>>();
        DescribeSObjectResult[] dsrArray = this.getPartnerConnection().describeSObjects(toLoad.toArray(new String[toLoad.size()]));
        int i = 0;
        while (i < dsrArray.length) {
            DescribeSObjectResult dsr = dsrArray[i];
            ArrayList<SFField> fields = new ArrayList<SFField>();
            Field[] fieldArray = dsr.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!f.getDeprecatedAndHidden()) {
                    fields.add(this.createSFField(f));
                }
                ++n2;
            }
            map.put(toLoad.get(i), fields);
            ++i;
        }
        return map;
    }

    public GetDeletedResult getDeleted(String sObjectType, Calendar startDate, Calendar endDate) throws ConnectionException {
        return this.partnerConnection.getDeleted(sObjectType, startDate, endDate);
    }

    public void setAuthenticationProperties(String authenticationProperties) throws Exception {
        OAuth2Metadata otmd = new OAuth2Metadata();
        Properties properties = new Properties();
        String serviceEndpoint = null;
        properties.load(new ByteArrayInputStream(authenticationProperties.getBytes()));
        otmd.securityToken = this.securityToken;
        otmd.flowType = properties.getProperty("flowType");
        otmd.password = SalesForceConnection.decryptString(properties.getProperty("password"));
        otmd.login = properties.getProperty("username");
        otmd.tokenEndpoint = properties.getProperty("tokenEndpoint");
        otmd.clientId = properties.getProperty("clientId");
        otmd.clientSecret = SalesForceConnection.decryptString(properties.getProperty("clientSecret"));
        otmd.refreshToken = properties.getProperty("refreshToken");
        otmd.accessToken = properties.getProperty("accessToken");
        otmd.tokenEndpointHttpMethod = properties.getProperty("tokenEndpointHttpMethod") == null ? "POST" : properties.getProperty("tokenEndpointHttpMethod");
        otmd.clientCredentialPolicy = OAuth2Utils.computeClientCredentialPolicy((Properties)properties);
        otmd.proxyHost = this.proxyHost == null || this.proxyHost.isEmpty() ? null : this.proxyHost;
        otmd.proxyPort = this.proxyPort;
        otmd.proxyUser = this.proxyUsername;
        otmd.proxyPassword = this.proxyPassword;
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            if (((String)key).matches("properties\\.(.)\\.key") && properties.get(key).equals("instance_url")) {
                serviceEndpoint = properties.getProperty(((String)key).split(".key")[0]);
                continue;
            }
            if (((String)key).matches("authorizationParameter\\.(.)\\.key") && properties.get(key).equals("scope")) {
                otmd.scope = properties.getProperty(((String)key).split(".key")[0]);
                continue;
            }
            if (((String)key).matches("authorizationParameter\\.(.)\\.key") && properties.get(key).equals("state")) {
                otmd.state = properties.getProperty(((String)key).split(".key")[0]);
                continue;
            }
            if (((String)key).matches("authorizationParameter\\.(.)\\.key") && properties.get(key).equals("token_endpoint")) {
                otmd.tokenEndpoint = properties.getProperty(((String)key).split(".key")[0]);
                continue;
            }
            if (!((String)key).matches("authorizationParameter\\.(.*)\\.key")) continue;
            String parameterKey = properties.getProperty((String)key);
            String parameterValue = properties.getProperty(((String)key).split(".key")[0]);
            additionalParameters.put(parameterKey, parameterValue);
        }
        if (!additionalParameters.isEmpty()) {
            otmd.additionnalParameters = additionalParameters;
        }
        if (serviceEndpoint == null) {
            serviceEndpoint = this.authenticationEndPoint;
        }
        otmd.accessToken = OAuth2.getToken((OAuth2Metadata)otmd);
        if (otmd.accessToken != null) {
            this.setSessionId(otmd.accessToken);
        }
        if (serviceEndpoint != null) {
            this.setServiceEndpoint(serviceEndpoint);
        }
    }

    private static synchronized String decryptString(String expression) {
        if (expression != null && !expression.isEmpty()) {
            try {
                String decrypt;
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                expression = decrypt = semaphoreManager.getStringAsciiInfo(expression);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "unexpected", e);
            }
        }
        return expression;
    }

    private SFEntity createSFEntity(DescribeGlobalSObjectResult dgor) {
        SFEntity sfe = new SFEntity();
        sfe.custom = dgor.getCustom();
        sfe.deletable = dgor.getDeletable();
        sfe.keyprefix = dgor.getKeyPrefix();
        sfe.label = dgor.getLabel();
        sfe.pluralLabel = dgor.getLabelPlural();
        sfe.name = dgor.getName();
        sfe.updatable = dgor.getUpdateable();
        sfe.createable = dgor.getCreateable();
        return sfe;
    }

    private SFField createSFField(Field f) {
        SFField sfe = new SFField();
        sfe.autoNumber = f.getAutoNumber();
        sfe.byteLength = f.getByteLength();
        sfe.calculated = f.getCalculated();
        sfe.formula = f.getCalculatedFormula();
        sfe.deleteOnCascade = f.getCascadeDelete();
        sfe.caseSensitive = f.getCaseSensitive();
        sfe.createable = f.getCreateable();
        sfe.custom = f.getCustom();
        sfe.defaultOnCreate = f.getDefaultedOnCreate();
        sfe.defaultValueFormula = f.getDefaultValueFormula();
        sfe.dependPickList = f.getDependentPicklist();
        sfe.digits = f.getDigits();
        sfe.displayLocationInDecimal = f.getDisplayLocationInDecimal();
        sfe.externalId = f.getExternalId();
        sfe.filterable = f.getFilterable();
        sfe.groupable = f.getGroupable();
        sfe.htmlFormatted = f.getHtmlFormatted();
        sfe.idLookup = f.getIdLookup();
        sfe.inlineHelpText = f.getInlineHelpText();
        sfe.label = f.getLabel();
        sfe.length = f.getLength();
        sfe.name = f.getName();
        sfe.nameField = f.getNameField();
        sfe.nillable = f.getNillable();
        Object[] objectArray = f.getPicklistValues();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            PicklistEntry e = objectArray[n2];
            if (e.getActive()) {
                sfe.authorizedValues.put(e.getValue(), e.getLabel());
            }
            ++n2;
        }
        sfe.precision = f.getPrecision();
        f.getReferenceTo();
        sfe.relationshipName = f.getRelationshipName();
        sfe.relationshipOrder = f.getRelationshipOrder();
        sfe.restrictedDelete = f.getRestrictedDelete();
        sfe.restrictedDelete = f.getRestrictedPicklist();
        sfe.scale = f.getScale();
        sfe.soapType = f.getSoapType().name();
        sfe.sortable = f.getSortable();
        sfe.type = f.getType().name();
        sfe.unique = f.getUnique();
        sfe.updateable = f.getUpdateable();
        sfe.writeRequiresMasterRead = f.getWriteRequiresMasterRead();
        objectArray = f.getReferenceTo();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            PicklistEntry s = objectArray[n2];
            sfe.references.add(s);
            ++n2;
        }
        return sfe;
    }

    public void setDisableLogout(boolean disableLogout) {
        this.disableLogout = disableLogout;
    }

    public class ResultSet
    implements IResultSet,
    IResultSetMetadata {
        QueryResult qr;
        SObject[] records;
        int currentRecord = -1;
        boolean done = false;
        private Map<String, Integer> fieldsName;

        protected ResultSet(QueryResult qr) {
            this.qr = qr;
            this.records = qr.getRecords();
        }

        @Override
        public boolean next() throws Exception {
            if (this.done) {
                return !this.done;
            }
            if (this.qr.getSize() > 0) {
                ++this.currentRecord;
                if (this.currentRecord < this.records.length) {
                    if (this.currentRecord == 0) {
                        this.fieldsName = new HashMap<String, Integer>();
                        SObject so = this.qr.getRecords()[this.currentRecord];
                        int i = 0;
                        Iterator it = so.getChildren();
                        while (it.hasNext()) {
                            XmlObject xo = (XmlObject)it.next();
                            this.fieldsName.put(xo.getName().getLocalPart(), i++);
                        }
                    }
                    return true;
                }
                if (this.qr.isDone()) {
                    this.done = true;
                    this.records = null;
                    return false;
                }
                this.qr = SalesForceConnection.this.getPartnerConnection().queryMore(this.qr.getQueryLocator());
                this.records = this.qr.getRecords();
                this.currentRecord = 0;
                return true;
            }
            return false;
        }

        private String readField(String fieldName) throws Exception {
            Object val = this.records[this.currentRecord].getField(fieldName);
            return val != null ? val.toString() : null;
        }

        @Override
        public String getString(String fieldName) throws Exception {
            return this.readField(fieldName);
        }

        @Override
        public void close() throws Exception {
            this.records = null;
        }

        @Override
        public String[] getFieldNames() throws Exception {
            if (this.fieldsName == null) {
                throw new Exception(Messages.getString("SalesForceConnection.6"));
            }
            String[] str = new String[this.fieldsName.size()];
            this.fieldsName.keySet().toArray(str);
            return str;
        }
    }
}

