/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.bind;

import com.indy.engine.actionCodes.utils.XmlDataTypeProvider;
import com.stambia.salesforce.connector.bind.Messages;
import java.util.LinkedHashMap;

public abstract class AbstractTypeBinder {
    private int[] xmlDataType;
    private int[] jdbcDataType;
    private LinkedHashMap<String, String> fieldTypes;
    private XmlDataTypeProvider dataTypeProvider;

    protected void setFieldTypes(LinkedHashMap<String, String> fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    protected final void prepareDataTypes() throws Exception {
        if (this.fieldTypes == null) {
            throw new Exception(Messages.getString("AbstractTypeBinder.0"));
        }
        this.dataTypeProvider = new XmlDataTypeProvider();
        this.xmlDataType = new int[this.fieldTypes.size()];
        this.jdbcDataType = new int[this.fieldTypes.size()];
        int i = 0;
        for (String fieldName : this.fieldTypes.keySet()) {
            if (this.fieldTypes.get(fieldName) == null) {
                throw new Exception(Messages.getString("AbstractTypeBinder.1") + fieldName);
            }
            this.xmlDataType[i] = this.dataTypeProvider.getDataType(this.fieldTypes.get(fieldName));
            this.jdbcDataType[i] = this.dataTypeProvider.getJavaDataType(this.xmlDataType[i]);
            ++i;
        }
    }

    protected XmlDataTypeProvider getDataProvider() {
        return this.dataTypeProvider;
    }

    public int[] getDataType() throws Exception {
        return this.jdbcDataType;
    }

    public int getDataType(int index) throws Exception {
        return this.jdbcDataType[index];
    }

    protected int getXmlDataType(int index) throws Exception {
        return this.xmlDataType[index];
    }
}

