/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.bind;

import com.indy.runtime.api.IBindWriter;
import com.stambia.salesforce.connector.bind.AbstractTypeBinder;
import com.stambia.salesforce.connector.bind.Messages;
import com.stambia.salesforce.connector.util.SFBatch;
import com.stambia.salesforce.connector.util.SalesForceHelper;
import java.util.LinkedHashMap;

public class SalesForceBindWriter
extends AbstractTypeBinder
implements IBindWriter {
    public static final String BULK_ENDPOINT = "com.stambia.salesforce.connector.bind.bulkEndPoint";
    public static final String SESSION_ID = "com.stambia.salesforce.connector.bind.sessionId";
    public static final String JOB_ID = "com.stambia.salesforce.connector.bind.jobId";
    public static final String MAP_FIELD_NAME_TYPE_ = "com.stambia.salesforce.connector.bind.fieldTypeMap";
    public static final String BATCH_SIZE = "com.stambia.salesforce.connector.bind.batchSize";
    private String sessionId;
    private String jobId;
    private String bulkEndPoint;
    private Integer batchSize;
    private SFBatch batch;
    private String[] fieldNames;
    private String[] currentRow;

    public void setParameter(String name, Object value) throws Exception {
        if (BATCH_SIZE.equals(name)) {
            this.batchSize = (Integer)value;
        } else if (JOB_ID.equals(name)) {
            this.jobId = (String)value;
        } else if (SESSION_ID.equals(name)) {
            this.sessionId = (String)value;
        } else if (BULK_ENDPOINT.equals(name)) {
            this.bulkEndPoint = (String)value;
        } else if (MAP_FIELD_NAME_TYPE_.equals(name)) {
            LinkedHashMap fieldMap = (LinkedHashMap)value;
            this.setFieldTypes(fieldMap);
            this.fieldNames = new String[fieldMap.size()];
            int i = 0;
            for (String s : fieldMap.keySet()) {
                this.fieldNames[i++] = s;
            }
        }
    }

    public void setValue(int index, Object value) throws Exception {
        String data;
        this.currentRow[index] = data = this.getDataProvider().getUnparser().print(value, this.getXmlDataType(index));
    }

    public void prepare() throws Exception {
        if (this.sessionId == null) {
            throw new Exception(Messages.getString("SalesForceBindWriter.0") + SESSION_ID + Messages.getString("SalesForceBindWriter.1"));
        }
        if (this.jobId == null) {
            throw new Exception(Messages.getString("SalesForceBindWriter.2") + JOB_ID + Messages.getString("SalesForceBindWriter.3"));
        }
        if (this.batchSize == null) {
            throw new Exception(Messages.getString("SalesForceBindWriter.4") + BATCH_SIZE + Messages.getString("SalesForceBindWriter.5"));
        }
        if (this.bulkEndPoint == null) {
            throw new Exception(Messages.getString("SalesForceBindWriter.6") + BULK_ENDPOINT + Messages.getString("SalesForceBindWriter.7"));
        }
        super.prepareDataTypes();
        this.batch = new SFBatch(this.sessionId, this.jobId, this.bulkEndPoint, this.batchSize);
        int i = 0;
        while (i < this.fieldNames.length) {
            this.batch.addHeader(this.fieldNames[i]);
            ++i;
        }
    }

    public boolean writeNext() throws Exception {
        if (this.currentRow != null) {
            String[] stringArray = this.currentRow;
            int n = this.currentRow.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.batch.addValue(s);
                ++n2;
            }
        }
        this.currentRow = new String[this.fieldNames.length];
        this.batch.addRow();
        return true;
    }

    public void close() throws Exception {
        if (this.currentRow != null) {
            String[] stringArray = this.currentRow;
            int n = this.currentRow.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.batch.addValue(s);
                ++n2;
            }
        }
        if (this.batch != null) {
            this.batch.end();
        }
        SalesForceHelper.closeJob(this.sessionId, this.jobId, this.bulkEndPoint);
    }
}

