/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.object;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BulkConnection;
import com.sforce.async.Error;
import com.sforce.async.Result;
import com.sforce.async.StatusCode;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.Logger;

public class BatchResultStreamIterator
implements Iterator<Result>,
Closeable {
    private final XMLStreamReader reader;
    private final Logger logger;
    private Result result = new Result();

    public BatchResultStreamIterator(BulkConnection bulkConnection, String jobId, String batchId, Logger logger) throws AsyncApiException {
        this.logger = logger;
        InputStream inputStream = bulkConnection.getBatchResultStream(jobId, batchId);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            this.reader = xmlInputFactory.createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e) {
            AsyncApiException superError = new AsyncApiException();
            superError.setExceptionMessage(e.getMessage());
            superError.setStackTrace(e.getStackTrace());
            throw superError;
        }
    }

    @Override
    public boolean hasNext() {
        this.result = null;
        try {
            while (this.reader.hasNext() && this.result == null) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        String rawText = this.reader.getName().getLocalPart();
                        Markup markup = Markup.fromString(rawText);
                        if (markup == null) break;
                        switch (markup) {
                            case RESULT: {
                                this.result = new Result();
                            }
                        }
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return this.result != null;
    }

    @Override
    public Result next() {
        if (this.result == null) {
            throw new NoSuchElementException();
        }
        try {
            boolean endResult = false;
            Context context = null;
            ErrorRawStatusCode error = new ErrorRawStatusCode();
            ArrayList<Error> errors = new ArrayList<Error>();
            StringBuilder rawTextBuffer = new StringBuilder();
            while (this.reader.hasNext() && !endResult) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        context = this.handleStartElement();
                        if (context == null) break;
                        rawTextBuffer = new StringBuilder();
                        break;
                    }
                    case 4: {
                        if (context == null) break;
                        rawTextBuffer.append(this.reader.getText());
                        break;
                    }
                    case 2: {
                        endResult = this.handleEndElement(rawTextBuffer, errors, error, endResult);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return this.result;
    }

    private Context handleStartElement() {
        Context context = null;
        String rawText = this.reader.getName().getLocalPart();
        Markup markup = Markup.fromString(rawText);
        if (markup != null) {
            switch (markup) {
                case ID: {
                    context = Context.ID;
                    break;
                }
                case SUCCESS: {
                    context = Context.SUCCESS;
                    break;
                }
                case CREATED: {
                    context = Context.CREATED;
                    break;
                }
                case MESSAGE: {
                    context = Context.MESSAGE;
                    break;
                }
                case FIELDS: {
                    context = Context.FIELD_NAME;
                    break;
                }
                case STATUS_CODE: {
                    context = Context.STATUS_CODE;
                    break;
                }
                default: {
                    context = null;
                }
            }
        }
        return context;
    }

    private boolean handleEndElement(StringBuilder rawTextBuffer, List<Error> errors, ErrorRawStatusCode error, boolean endResult) {
        String rawText = this.reader.getName().getLocalPart();
        Markup markup = Markup.fromString(rawText);
        if (markup != null) {
            rawText = rawTextBuffer.toString();
            switch (markup) {
                case ID: {
                    this.result.setId(rawText);
                    break;
                }
                case SUCCESS: {
                    this.result.setSuccess(Boolean.valueOf(rawText).booleanValue());
                    break;
                }
                case CREATED: {
                    this.result.setCreated(Boolean.valueOf(rawText).booleanValue());
                    break;
                }
                case MESSAGE: {
                    error.setMessage(rawText);
                    break;
                }
                case FIELDS: {
                    error.addField(rawText);
                    break;
                }
                case STATUS_CODE: {
                    error.setRawStatusCode(rawText);
                    break;
                }
                case ERRORS: {
                    error.commitFields();
                    errors.add(new ErrorRawStatusCode(error));
                    error.clean();
                    break;
                }
                case RESULT: {
                    this.result.setErrors(errors.toArray(new Error[errors.size()]));
                    endResult = true;
                }
            }
        }
        return endResult;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
    }

    private static enum Context {
        ID,
        SUCCESS,
        CREATED,
        MESSAGE,
        STATUS_CODE,
        FIELD_NAME;

    }

    public static class ErrorRawStatusCode
    extends Error {
        private String rawStatusCode;
        private List<String> tempFields = new ArrayList<String>();

        public ErrorRawStatusCode() {
        }

        public ErrorRawStatusCode(ErrorRawStatusCode errorRawStatusCode) {
            this.setRawStatusCode(errorRawStatusCode.rawStatusCode);
            this.setMessage(errorRawStatusCode.getMessage());
            this.tempFields = new ArrayList<String>();
            for (String field : errorRawStatusCode.tempFields) {
                this.addField(field);
            }
            this.commitFields();
        }

        public void clean() {
            this.setRawStatusCode(null);
            this.setMessage(null);
            this.tempFields.clear();
            this.commitFields();
        }

        public void setRawStatusCode(String rawStatusCode) {
            this.rawStatusCode = rawStatusCode;
            if (rawStatusCode != null) {
                StatusCode statusCode = StatusCode.valueOf((String)rawStatusCode);
                this.setStatusCode(statusCode);
            } else {
                this.setStatusCode(null);
            }
        }

        public String getRawStatusCode() {
            return this.rawStatusCode;
        }

        public void addField(String field) {
            this.tempFields.add(field);
        }

        public void commitFields() {
            int fieldsNumber = this.tempFields.size();
            String[] fields = new String[fieldsNumber];
            fields = this.tempFields.toArray(fields);
            this.setFields(fields);
        }
    }

    private static enum Markup {
        RESULT("result"),
        ID("id"),
        SUCCESS("success"),
        CREATED("created"),
        MESSAGE("message"),
        STATUS_CODE("statusCode"),
        ERRORS("errors"),
        FIELDS("fields");

        private String value;

        private Markup(String value) {
            this.value = value;
        }

        public static Markup fromString(String candidate) {
            Markup resultMarkup = null;
            Markup[] markupArray = Markup.values();
            int n = markupArray.length;
            int n2 = 0;
            while (n2 < n) {
                Markup currentMarkup = markupArray[n2];
                if (currentMarkup.value.equals(candidate)) {
                    resultMarkup = currentMarkup;
                    break;
                }
                ++n2;
            }
            return resultMarkup;
        }
    }
}

