/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.object;

import com.sforce.async.AsyncApiException;
import com.sforce.async.AsyncExceptionCode;
import com.sforce.async.BatchInfo;
import com.sforce.async.BulkConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.parser.PullParserException;
import com.sforce.ws.parser.XmlInputStream;
import com.sforce.ws.transport.Transport;
import com.stambia.salesforce.connector.object.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CsvBatchRequest {
    private final OutputStream csvStream;
    private final Transport transport;
    private boolean isNew;
    private final String UTF8 = "UTF-8";

    public CsvBatchRequest(Transport transport, OutputStream out) throws IOException {
        this.transport = transport;
        this.csvStream = out;
        this.isNew = true;
    }

    public void addHeader(String[] columns) throws AsyncApiException {
        if (!this.isNew) {
            throw new AsyncApiException(Messages.getString("CsvBatchRequest.0"), AsyncExceptionCode.ClientInputError);
        }
        this.addRow(columns);
    }

    public void addRow(String[] columns) throws AsyncApiException {
        try {
            this.csvStream.write("\n".getBytes("UTF-8"));
            int i = 0;
            while (i < columns.length) {
                if (i == 0) {
                    this.addColumn(columns[i]);
                } else {
                    this.addSecondColumn(columns[i]);
                }
                ++i;
            }
            this.isNew = false;
        }
        catch (IOException e) {
            throw new AsyncApiException(Messages.getString("CsvBatchRequest.1"), AsyncExceptionCode.ClientInputError, (Throwable)e);
        }
    }

    public BatchInfo completeRequest() throws AsyncApiException {
        try {
            this.csvStream.close();
            InputStream in = this.transport.getContent();
            if (this.transport.isSuccessful()) {
                BatchInfo info = new BatchInfo();
                XmlInputStream xin = new XmlInputStream();
                xin.setInput(in, "UTF-8");
                info.load(xin, BulkConnection.typeMapper);
                return info;
            }
        }
        catch (IOException e) {
            throw new AsyncApiException(Messages.getString("CsvBatchRequest.2"), AsyncExceptionCode.ClientInputError, (Throwable)e);
        }
        catch (PullParserException e) {
            throw new AsyncApiException(Messages.getString("CsvBatchRequest.3"), AsyncExceptionCode.ClientInputError, (Throwable)e);
        }
        catch (ConnectionException e) {
            throw new AsyncApiException(Messages.getString("CsvBatchRequest.4"), AsyncExceptionCode.ClientInputError, (Throwable)e);
        }
        return null;
    }

    private void addSecondColumn(String value) throws IOException {
        this.csvStream.write(",".getBytes("UTF-8"));
        this.addColumn(value);
    }

    private void addColumn(String value) throws IOException {
        if (value != null) {
            this.csvStream.write("\"".getBytes("UTF-8"));
            this.csvStream.write(value.replace("\"", "\"\"").getBytes("UTF-8"));
            this.csvStream.write("\"".getBytes("UTF-8"));
        }
    }
}

