/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.util;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.BulkConnection;
import com.sforce.async.JobInfo;
import com.stambia.salesforce.connector.exceptions.BulkQueryProcessingException;
import com.stambia.salesforce.connector.util.Messages;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class BatchIterator
implements Iterator<BatchInfo> {
    private BulkConnection bulkConnection;
    private long pollint;
    String mainJobId;
    String mainBatchId;
    BatchReader b = new BatchReader();
    BatchInfo next;
    BatchInfo current;

    public BatchIterator(BulkConnection bulkConnection, String mainJobId, String mainBatchId, long pollint) {
        this.bulkConnection = bulkConnection;
        this.mainJobId = mainJobId;
        this.mainBatchId = mainBatchId;
        this.pollint = pollint;
    }

    private BatchInfo _next() {
        int i = 0;
        do {
            try {
                i = this.b.newCompletedBatchInfo();
                if (i <= 1) continue;
                Thread.sleep(this.pollint);
            }
            catch (AsyncApiException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        } while (i > 1);
        if (i == 1) {
            return this.b.current;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        this.fillNext();
        return this.next != null;
    }

    private void fillNext() {
        if (this.next == null) {
            this.next = this._next();
        }
    }

    @Override
    public BatchInfo next() {
        this.fillNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = null;
        return this.current;
    }

    @Override
    public void remove() {
    }

    class BatchReader {
        BatchInfo current;
        Set<String> completedBatch = new HashSet<String>();

        BatchReader() {
        }

        int newCompletedBatchInfo() throws AsyncApiException {
            this.current = null;
            BatchInfo[] statusList = BatchIterator.this.bulkConnection.getBatchInfoList(BatchIterator.this.mainJobId).getBatchInfo();
            JobInfo jobInfo = BatchIterator.this.bulkConnection.getJobStatus(BatchIterator.this.mainJobId);
            HashMap<String, BatchInfo> all = new HashMap<String, BatchInfo>();
            int running = 0;
            BatchInfo[] batchInfoArray = statusList;
            int n = statusList.length;
            int n2 = 0;
            while (n2 < n) {
                BatchInfo b = batchInfoArray[n2];
                all.put(b.getId(), b);
                if (this.current == null && b.getState() == BatchStateEnum.Completed && !this.completedBatch.contains(b.getId())) {
                    this.current = b;
                    this.completedBatch.add(b.getId());
                } else {
                    if (b.getState() == BatchStateEnum.Failed) {
                        throw new BulkQueryProcessingException(String.format(Messages.getString("BatchIterator.0"), jobInfo.getObject(), b.getId(), b.getStateMessage()));
                    }
                    if (b.getState() == BatchStateEnum.Queued || b.getState() == BatchStateEnum.InProgress) {
                        ++running;
                    }
                }
                ++n2;
            }
            if (this.current != null) {
                return 1;
            }
            if (running > 0) {
                return 3;
            }
            return 0;
        }
    }
}

