/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.util;

import com.stambia.salesforce.connector.util.Messages;
import com.stambia.salesforce.connector.util.SalesForceHelper;
import java.util.ArrayList;
import java.util.List;

public class SFBatch {
    private StringBuffer buf = new StringBuffer();
    private String firstRow;
    private List<String> columnNames = new ArrayList<String>();
    private boolean newRow = false;
    private int batchSize;
    private int currentRowNumber;
    private String sessionId;
    private String jobId;
    private String salesForceEndpoint;
    private int columnCount = 0;
    private int currentColumnCount = 0;
    private StringBuffer results = new StringBuffer();

    public SFBatch(String sessionId, String jobId, String salesForceEndpoint, int batchSize) throws Exception {
        this.sessionId = sessionId;
        this.jobId = jobId;
        this.salesForceEndpoint = salesForceEndpoint;
        this.batchSize = batchSize;
        if (batchSize <= 0) {
            throw new Exception(Messages.getString("SFBatch.0"));
        }
    }

    public void addHeader(String header) throws Exception {
        if (this.firstRow != null) {
            throw new Exception(Messages.getString("SFBatch.1"));
        }
        this.columnNames.add(header);
        ++this.columnCount;
    }

    private static String enquote(String value) {
        if (value == null) {
            return "\"\"";
        }
        String ret = new String(value);
        if (ret.contains("\"")) {
            ret = ret.replace("\"", "\"\"");
        }
        return "\"" + ret + "\"";
    }

    private void init() {
        if (this.firstRow == null) {
            for (String s : this.columnNames) {
                this.firstRow = this.firstRow != null ? String.valueOf(this.firstRow) + "," : "";
                this.firstRow = String.valueOf(this.firstRow) + SFBatch.enquote(s);
            }
            this.columnNames.clear();
            this.columnNames = null;
        }
        this.buf = new StringBuffer();
        this.currentRowNumber = 0;
        this.buf.append(this.firstRow);
    }

    public void addRow() throws Exception {
        if (this.firstRow == null) {
            this.init();
        } else {
            if (this.currentColumnCount != this.columnCount) {
                throw new Exception(Messages.getString("SFBatch.2") + this.columnCount + Messages.getString("SFBatch.3"));
            }
            if (this.currentRowNumber >= this.batchSize) {
                this.flush();
                this.init();
            }
        }
        this.buf.append("\n");
        this.newRow = true;
        ++this.currentRowNumber;
        this.currentColumnCount = 0;
    }

    public String end() throws Exception {
        if (this.currentRowNumber > 0) {
            if (this.currentColumnCount != this.columnCount) {
                throw new Exception(Messages.getString("SFBatch.4") + this.columnCount + Messages.getString("SFBatch.5"));
            }
            this.flush();
        }
        String res = this.results.toString();
        this.firstRow = null;
        this.results = null;
        return res;
    }

    public void addValue(String value) {
        if (!this.newRow) {
            this.buf.append(",");
        }
        this.buf.append(SFBatch.enquote(value));
        this.newRow = false;
        ++this.currentColumnCount;
    }

    private void flush() throws Exception {
        if (this.results.length() > 0) {
            this.results.append(",");
        }
        this.results.append(SalesForceHelper.createBatch(this.sessionId, this.jobId, this.buf.toString(), this.salesForceEndpoint));
    }
}

