/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.util;

import com.sforce.async.ConcurrencyMode;
import com.sforce.soap.partner.DeletedRecord;
import com.sforce.soap.partner.GetDeletedResult;
import com.stambia.salesforce.connector.IResultSet;
import com.stambia.salesforce.connector.IResultSetMetadata;
import com.stambia.salesforce.connector.SalesForceBulkConnection;
import com.stambia.salesforce.connector.SalesForceConnection;
import java.io.OutputStream;
import java.util.Calendar;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

public class SFQueryToXml
implements AutoCloseable {
    private SalesForceConnection conn;
    private OutputStream os;
    private XMLEventWriter writer;
    private XMLEventFactory eventFactory;
    private boolean dataAsAttribute = true;
    SForceToXmlHandler handler = null;
    ConcurrencyMode mode = ConcurrencyMode.Serial;
    boolean enableBulk;

    public void setHandler(SForceToXmlHandler sForceToXmlHandler) {
        this.handler = sForceToXmlHandler;
    }

    public SFQueryToXml(SalesForceConnection conn, OutputStream os, boolean dataAsAttribute) throws FactoryConfigurationError {
        this.conn = conn;
        this.os = os;
        this.dataAsAttribute = dataAsAttribute;
    }

    public void startDocument() throws XMLStreamException {
        this.writer = XMLOutputFactory.newFactory().createXMLEventWriter(this.os, "UTF-8");
        this.eventFactory = XMLEventFactory.newFactory();
        this.writer.add(this.eventFactory.createStartDocument());
        this.writer.add(this.eventFactory.createStartElement("", null, "SForceExchange"));
    }

    public void endDocument() throws XMLStreamException {
        this.writer.add(this.eventFactory.createEndElement("", null, "SForceExchange"));
        this.writer.add(this.eventFactory.createEndDocument());
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    public long dump(String query, String sObjectName, boolean delete, Calendar deletetionStartDate, Calendar deletetionEndDate, int deleteOffsetUnit, int deleteOffset) throws Exception {
        int data = 0;
        try (IResultSet rs = null;){
            rs = this.enableBulk ? ((SalesForceBulkConnection)this.conn).executeQuery(sObjectName, query, this.mode) : this.conn.executeQuery(query);
            IResultSetMetadata md = (IResultSetMetadata)((Object)rs);
            String[] fieldNames = null;
            int recordNb = 0;
            while (rs.next()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                ++recordNb;
                ++data;
                this.writer.add(this.eventFactory.createStartElement("", null, sObjectName));
                if (fieldNames == null) {
                    fieldNames = md.getFieldNames();
                }
                String[] stringArray = fieldNames;
                int n = fieldNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fieldName = stringArray[n2];
                    String value = rs.getString(fieldName);
                    this.writeField(fieldName, value);
                    ++n2;
                }
                this.writer.add(this.eventFactory.createEndElement("", null, sObjectName));
                if (recordNb != 1000) continue;
                this.fireEvent(recordNb);
                recordNb = 0;
            }
            if (delete) {
                Calendar deleteEndDate = deletetionEndDate;
                Calendar deleteStartDate = deletetionStartDate;
                if (deleteEndDate == null) {
                    deleteEndDate = this.conn.getPartnerConnection().getServerTimestamp().getTimestamp();
                }
                if (deleteStartDate == null) {
                    deleteStartDate = (Calendar)deleteEndDate.clone();
                    deleteStartDate.add(deleteOffsetUnit, -deleteOffset);
                }
                GetDeletedResult gdr = this.conn.getDeleted(sObjectName, deleteStartDate, deleteEndDate);
                DeletedRecord[] deletedRecordArray = gdr.getDeletedRecords();
                int n = deletedRecordArray.length;
                int n3 = 0;
                while (n3 < n) {
                    DeletedRecord dr = deletedRecordArray[n3];
                    this.writer.add(this.eventFactory.createStartElement("", null, sObjectName));
                    this.writeField("Id", dr.getId());
                    this.writeField("IsDeleted", "true");
                    this.writer.add(this.eventFactory.createEndElement("", null, sObjectName));
                    if (++recordNb == 1000) {
                        this.fireEvent(recordNb);
                        recordNb = 0;
                    }
                    ++n3;
                }
            }
            if (recordNb > 0) {
                this.fireEvent(recordNb);
            }
            long l = data;
            return l;
        }
    }

    private void writeField(String fieldName, String value) throws XMLStreamException {
        if (value != null) {
            if (this.dataAsAttribute) {
                this.writer.add(this.eventFactory.createAttribute(fieldName, value));
            } else {
                this.writer.add(this.eventFactory.createStartElement("", null, fieldName));
                this.writer.add(this.eventFactory.createCharacters(value));
                this.writer.add(this.eventFactory.createEndElement("", null, fieldName));
            }
        }
    }

    private void fireEvent(int recordNb) {
        if (this.handler != null) {
            this.handler.handleBatch(recordNb);
        }
    }

    public void enableBulk(boolean enableBulk) {
        this.enableBulk = enableBulk;
    }

    public void setConcurrencyMode(ConcurrencyMode sForceBulkConcurrencyMode) {
        this.mode = sForceBulkConcurrencyMode;
    }

    public static interface SForceToXmlHandler {
        public void handleBatch(int var1);
    }
}

