/*
 * Decompiled with CFR 0.152.
 */
package endolabs.salesforce.bulkv2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.io.UncheckedIOException;

final class Json {
    private static final ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    Json() {
    }

    static String encode(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static <T> T decode(String json, Class<T> type) {
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static <T> T decode(String json, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

