/*
 * Decompiled with CFR 0.152.
 */
package endolabs.salesforce.bulkv2;

import com.fasterxml.jackson.core.type.TypeReference;
import endolabs.salesforce.bulkv2.BulkRequestException;
import endolabs.salesforce.bulkv2.Json;
import endolabs.salesforce.bulkv2.Messages;
import endolabs.salesforce.bulkv2.request.CreateJobRequest;
import endolabs.salesforce.bulkv2.response.ErrorResponse;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Pair;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestRequester {
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType CSV_MEDIA_TYPE = MediaType.parse((String)"text/csv");
    private static final TypeReference<List<ErrorResponse>> ERRORS_TYPE_REFERENCE = new TypeReference<List<ErrorResponse>>(){};
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final OkHttpClient client;

    public RestRequester(OkHttpClient client) {
        this.client = client;
    }

    public <T> T putCsv(String url, File csvFile, Class<T> responseClass) {
        RequestBody requestBody = csvFile == null ? null : RequestBody.create((MediaType)CSV_MEDIA_TYPE, (File)csvFile);
        return this.request(url, "PUT", new HashMap<String, String>(), requestBody, responseClass);
    }

    public Reader getCsv(String url) {
        return this.request(url, "GET", new HashMap<String, String>(), null, Reader.class);
    }

    public <T> T get(String url, Class<T> responseClass) {
        return this.request(url, "GET", new HashMap<String, String>(), null, responseClass);
    }

    public <T> T get(String url, Map<String, String> queryParams, Class<T> responseClass) {
        return this.request(url, "GET", queryParams, null, responseClass);
    }

    public <T> T post(String url, Object requestData, Class<T> responseClass) {
        Object transformedRequest = requestData;
        if (requestData instanceof CreateJobRequest) {
            RequestBody content;
            CreateJobRequest createJob = (CreateJobRequest)requestData;
            Object object = createJob.getContent() != null ? RequestBody.create((MediaType)CSV_MEDIA_TYPE, (String)createJob.getContent()) : (content = createJob.getContentFile() != null ? RequestBody.create((MediaType)CSV_MEDIA_TYPE, (File)createJob.getContentFile()) : null);
            if (content != null) {
                transformedRequest = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("job", null, RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)Json.encode(requestData))).addFormDataPart("content", "content", content).build();
            }
        }
        return this.requestJson(url, "POST", new HashMap<String, String>(), transformedRequest, responseClass);
    }

    public <T> T put(String url, Object requestData, Class<T> responseClass) {
        return this.requestJson(url, "PUT", new HashMap<String, String>(), requestData, responseClass);
    }

    public <T> T delete(String url, Object requestData, Class<T> responseClass) {
        return this.requestJson(url, "DELETE", new HashMap<String, String>(), requestData, responseClass);
    }

    public <T> T patch(String url, Object requestData, Class<T> responseClass) {
        return this.requestJson(url, "PATCH", new HashMap<String, String>(), requestData, responseClass);
    }

    private <T> T requestJson(String url, String httpMethod, Map<String, String> queryParams, Object requestData, Class<T> responseClass) {
        RequestBody requestBody = requestData == null ? null : (requestData instanceof RequestBody ? (RequestBody)requestData : RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)Json.encode(requestData)));
        return this.request(url, httpMethod, queryParams, requestBody, responseClass);
    }

    private Response doRequest(Request request) {
        try {
            return this.client.newCall(request).execute();
        }
        catch (IOException e) {
            throw new BulkRequestException(e);
        }
    }

    private ResponseBody unwrap(Response response) {
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            throw new BulkRequestException(Messages.getString("RestRequester.0"));
        }
        return responseBody;
    }

    private <T> T request(String url, String httpMethod, Map<String, String> queryParams, RequestBody requestBody, Class<T> responseClass) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
        queryParams.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        Request request = new Request.Builder().url(urlBuilder.build()).method(httpMethod, requestBody).build();
        if (responseClass.isAssignableFrom(Reader.class)) {
            ResponseBody responseBody = this.unwrap(this.doRequest(request));
            return (T)responseBody.charStream();
        }
        if (responseClass.isAssignableFrom(Collection.class)) {
            Response response = this.doRequest(request);
            ResponseBody responseBody = this.unwrap(this.doRequest(request));
            Headers responseHeaders = response.headers();
            Pair out = new Pair((Object)responseHeaders.toMultimap(), (Object)responseBody.charStream());
            return (T)out;
        }
        Throwable throwable = null;
        Object var10_13 = null;
        try (Response response = this.doRequest(request);){
            ResponseBody responseBody = this.unwrap(response);
            String body = null;
            try {
                body = responseBody.string();
                responseBody.close();
            }
            catch (IOException e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
            if (response.isSuccessful()) {
                T t = body == null || body.isEmpty() ? null : (T)Json.decode(body, responseClass);
                return t;
            }
            try {
                List<ErrorResponse> errors = Json.decode(body, ERRORS_TYPE_REFERENCE);
                throw new BulkRequestException(errors);
            }
            catch (UncheckedIOException e) {
                throw new BulkRequestException(Messages.getString("RestRequester.1") + body);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

