/*
 * Decompiled with CFR 0.152.
 */
package endolabs.salesforce.bulkv2.request;

import endolabs.salesforce.bulkv2.type.ColumnDelimiterEnum;
import endolabs.salesforce.bulkv2.type.ContentTypeEnum;
import endolabs.salesforce.bulkv2.type.LineEndingEnum;
import endolabs.salesforce.bulkv2.type.OperationEnum;

public class CreateQueryJob {
    private final ColumnDelimiterEnum columnDelimiter;
    private final ContentTypeEnum contentType;
    private final LineEndingEnum lineEnding;
    private final String query;
    private final OperationEnum operation;

    public ColumnDelimiterEnum getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public LineEndingEnum getLineEnding() {
        return this.lineEnding;
    }

    public String getQuery() {
        return this.query;
    }

    public OperationEnum getOperation() {
        return this.operation;
    }

    private CreateQueryJob(Builder builder) {
        this.columnDelimiter = builder.columnDelimiter;
        this.contentType = builder.contentType;
        this.lineEnding = builder.lineEnding;
        this.query = builder.query;
        this.operation = builder.operation;
    }

    public static class Builder {
        private String query;
        private OperationEnum operation;
        private ColumnDelimiterEnum columnDelimiter;
        private ContentTypeEnum contentType;
        private LineEndingEnum lineEnding;

        public Builder(String query, OperationEnum operation) {
            this.query = query;
            this.operation = operation;
            this.contentType = ContentTypeEnum.CSV;
        }

        public Builder withColumnDelimiter(ColumnDelimiterEnum columnDelimiter) {
            this.columnDelimiter = columnDelimiter;
            return this;
        }

        public Builder withContentType(ContentTypeEnum contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder withLineEnding(LineEndingEnum lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        public CreateQueryJob build() {
            return new CreateQueryJob(this);
        }
    }
}

