/*
 * Decompiled with CFR 0.152.
 */
package endolabs.salesforce.bulkv2.request;

import endolabs.salesforce.bulkv2.type.ConcurrencyModeEnum;
import endolabs.salesforce.bulkv2.type.JobTypeEnum;
import java.util.HashMap;
import java.util.Map;

public class GetAllJobsRequest {

    public static class Builder {
        private ConcurrencyModeEnum concurrencyMode;
        private boolean isPkChunkingEnabled;
        private JobTypeEnum jobType;
        private String queryLocator;

        public Builder withConcurrencyMode(ConcurrencyModeEnum concurrencyMode) {
            this.concurrencyMode = concurrencyMode;
            return this;
        }

        public Builder pkChunkingEnabled() {
            this.isPkChunkingEnabled = true;
            return this;
        }

        public Builder withJobType(JobTypeEnum jobType) {
            this.jobType = jobType;
            return this;
        }

        public Builder withQueryLocator(String queryLocator) {
            this.queryLocator = queryLocator;
            return this;
        }

        public Map<String, String> buildParameters() {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (this.concurrencyMode != null) {
                queryParams.put("concurrencyMode", this.concurrencyMode.toJsonValue());
            }
            if (this.isPkChunkingEnabled) {
                queryParams.put("isPkChunkingEnabled", "true");
            }
            if (this.jobType != null) {
                queryParams.put("jobType", this.jobType.toJsonValue());
            }
            if (this.queryLocator != null) {
                queryParams.put("queryLocator", this.queryLocator);
            }
            return queryParams;
        }
    }
}

