/*
 * Decompiled with CFR 0.152.
 */
package endolabs.salesforce.bulkv2.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.EnumSet;

public enum JobStateEnum {
    OPEN("Open"),
    UPLOAD_COMPLETE("UploadComplete"),
    IN_PROGRESS("InProgress"),
    ABORTED("Aborted"),
    JOB_COMPLETE("JobComplete"),
    FAILED("Failed");

    private static EnumSet<JobStateEnum> FINISHED_STATUS;
    private static EnumSet<JobStateEnum> FAILED_STATUS;
    private final String value;

    static {
        FINISHED_STATUS = EnumSet.of(JOB_COMPLETE, FAILED, ABORTED);
        FAILED_STATUS = EnumSet.of(FAILED);
    }

    private JobStateEnum(String value) {
        this.value = value;
    }

    @JsonValue
    public String toJsonValue() {
        return this.value;
    }

    @JsonCreator
    public static JobStateEnum fromValue(String value) {
        return Arrays.stream(JobStateEnum.values()).filter(v -> v.value.equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.valueOf(value)));
    }

    public boolean isFinished() {
        return FINISHED_STATUS.contains((Object)this);
    }

    public boolean isFailed() {
        return FAILED_STATUS.contains((Object)this);
    }
}

