/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import net.bytebuddy.description.annotation.AnnotationDescription;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.util.StringUtils;

public class JavaIdentifierNormalizer {
    public static final String FIELD_NAME = "name";
    public static final AnnotationDescription.Builder FIELD_BUILDER = AnnotationDescription.Builder.ofType(Field.class);
    public static final AnnotationDescription DEFAULT_FIELD_ANNOTATION = FIELD_BUILDER.build();

    private JavaIdentifierNormalizer() {
    }

    public static String normalizeJavaClassName(String className) {
        return StringUtils.capitalize((String)JavaIdentifierNormalizer.normalizeJavaName(className));
    }

    public static Map<String, String> normalizeJavaFieldsNames(Set<String> fieldsNames) {
        HashMap<String, String> normalizeJavaFieldsNames = new HashMap<String, String>();
        for (String fieldName : fieldsNames) {
            String originalNodeNameJava = JavaIdentifierNormalizer.normalizeJavaName(fieldName);
            if (originalNodeNameJava.isEmpty()) {
                originalNodeNameJava = "_";
            }
            if (SourceVersion.isKeyword(originalNodeNameJava)) {
                originalNodeNameJava = originalNodeNameJava + '_';
            }
            String lastNodeNameJava = originalNodeNameJava;
            Collection<String> existingJavaFields = normalizeJavaFieldsNames.values();
            int offset = 0;
            while (existingJavaFields.contains(lastNodeNameJava)) {
                lastNodeNameJava = originalNodeNameJava + offset++;
            }
            normalizeJavaFieldsNames.put(fieldName, lastNodeNameJava);
        }
        return normalizeJavaFieldsNames;
    }

    private static String normalizeJavaName(String javaName) {
        char firstCharacter;
        StringBuilder cleanClassName = new StringBuilder();
        int i = 0;
        while (i < javaName.length()) {
            char currentCharacter = javaName.charAt(i);
            if (Character.isJavaIdentifierPart(currentCharacter)) {
                cleanClassName.append(currentCharacter);
            }
            ++i;
        }
        if (!cleanClassName.isEmpty() && !Character.isJavaIdentifierStart(firstCharacter = cleanClassName.charAt(0))) {
            cleanClassName = new StringBuilder("_").append((CharSequence)cleanClassName);
        }
        return cleanClassName.toString();
    }
}

