/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.common;

import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;

public class SslStore {
    private Store keyStore;
    private Store trustStore;
    private boolean enableCertificateValidation;

    public SslStore(Store keyStore, Store trustStore, boolean enableCertificateValidation) {
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.enableCertificateValidation = enableCertificateValidation;
    }

    public Store getTrustStore() {
        return this.trustStore;
    }

    public Store getKeyStore() {
        return this.keyStore;
    }

    public boolean isCertificateValidationEnabled() {
        return this.enableCertificateValidation;
    }

    public static class Store {
        private String password;
        private KeyStore keyStore;

        public Store(String path, String type, String password) throws ElasticSearchException {
            this.password = password;
            if (path != null && !path.isEmpty()) {
                Path storePath = Paths.get(path, new String[0]);
                try {
                    this.keyStore = KeyStore.getInstance(type);
                    this.loadKeyStore(storePath);
                }
                catch (Exception e) {
                    throw new ElasticSearchException(e);
                }
            }
        }

        private void loadKeyStore(Path storePath) throws ElasticSearchException {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream is = Files.newInputStream(storePath, new OpenOption[0]);){
                    this.keyStore.load(is, this.password.toCharArray());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }

        public String getPassword() {
            return this.password;
        }

        public KeyStore getStore() {
            return this.keyStore;
        }
    }
}

