/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.factory;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import com.semarchy.xdi.elasticsearch.common.JavaIdentifierNormalizer;
import com.semarchy.xdi.elasticsearch.json.SpringDataKeyword;
import com.semarchy.xdi.elasticsearch.springdata.SpringDataComponent;
import com.semarchy.xdi.elasticsearch.springdata.SpringDataDocumentModel;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformationCreator;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformationCreatorImpl;
import org.springframework.data.elasticsearch.repository.support.SimpleElasticsearchRepository;
import org.springframework.data.mapping.context.MappingContext;

public class SpringDataContextFactory {
    private static final String INDEX_NAME = "indexName";
    private final Map<String, Class<? extends SpringDataDocumentModel>> indexDocumentClasses = new HashMap<String, Class<? extends SpringDataDocumentModel>>();
    private final Map<String, SpringDataComponent<? extends SpringDataDocumentModel>> componentInstances = new HashMap<String, SpringDataComponent<? extends SpringDataDocumentModel>>();
    private static final String CONCRETE_DOCUMENT_IDENTIFIER = "Document";
    public static final String ABSTRACT_DOCUMENT_NAME = "Abstract" + "Document";
    private ClassLoader classLoader;
    private ElasticsearchOperations elasticsearchOperations;
    private ElasticsearchEntityInformationCreator entityInformationCreator;
    private Class<? extends SpringDataDocumentModel> abstractDocumentClass;
    private Map<String, Field> documentFields = new HashMap<String, Field>();
    private Map<String, String> keywordSurrogates = new HashMap<String, String>();

    public SpringDataContextFactory(ClassLoader classLoader, ElasticsearchClient elasticsearchClient, Set<String> indices, Map<String, Class<?>> fieldsTypes) {
        this.classLoader = classLoader;
        this.abstractDocumentClass = this.setAllFields((DynamicType.Builder<? extends SpringDataDocumentModel>)new ByteBuddy().subclass(SpringDataDocumentModel.class).name(ABSTRACT_DOCUMENT_NAME).modifiers(new ModifierContributor.ForType[]{TypeManifestation.ABSTRACT, Visibility.PUBLIC}), fieldsTypes).make().load(classLoader).getLoaded();
        Field[] fieldArray = this.abstractDocumentClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            fieldName = this.keywordSurrogates.getOrDefault(fieldName, fieldName);
            this.documentFields.put(fieldName, field);
            ++n2;
        }
        this.elasticsearchOperations = new ElasticsearchTemplate(elasticsearchClient);
        ElasticsearchConverter elasticsearchConverter = this.elasticsearchOperations.getElasticsearchConverter();
        MappingContext mappingContext = elasticsearchConverter.getMappingContext();
        this.entityInformationCreator = new ElasticsearchEntityInformationCreatorImpl(mappingContext);
        for (String index : indices) {
            Class<? extends SpringDataDocumentModel> documentClass = this.createConcreteDocumentClass(index);
            ElasticsearchRepository<? extends SpringDataDocumentModel, String> repository = this.createRepositoryInstance(documentClass);
            this.createComponentInstance(index, repository);
        }
    }

    private DynamicType.Builder<? extends SpringDataDocumentModel> setAllFields(DynamicType.Builder<? extends SpringDataDocumentModel> documentBuilder, Map<String, Class<?>> fieldsTypes) {
        for (Map.Entry<String, Class<?>> fieldEntry : fieldsTypes.entrySet()) {
            AnnotationDescription fieldAnnotation;
            String fieldName = fieldEntry.getKey();
            if (SpringDataKeyword.contains(fieldName)) {
                fieldAnnotation = JavaIdentifierNormalizer.FIELD_BUILDER.define("name", fieldName).build();
                Set<String> existingFieldNames = fieldsTypes.keySet();
                int offset = 0;
                String originalFieldName = fieldName;
                fieldName = originalFieldName + offset;
                while (existingFieldNames.contains(fieldName)) {
                    fieldName = originalFieldName + ++offset;
                }
                this.keywordSurrogates.put(originalFieldName, fieldName);
            } else {
                fieldAnnotation = JavaIdentifierNormalizer.DEFAULT_FIELD_ANNOTATION;
            }
            Class<?> fieldType = fieldEntry.getValue();
            documentBuilder = documentBuilder.defineField(fieldName, fieldType, new ModifierContributor.ForField[]{Visibility.PUBLIC}).annotateField(new AnnotationDescription[]{fieldAnnotation});
        }
        return documentBuilder;
    }

    public Map<String, Class<? extends SpringDataDocumentModel>> getIndexDocumentAssociation() {
        return this.indexDocumentClasses;
    }

    public Class<? extends SpringDataDocumentModel> getAbstractDocumentClass() {
        return this.abstractDocumentClass;
    }

    public Class<? extends SpringDataDocumentModel> getConcreteDocumentClass(String index) {
        return this.indexDocumentClasses.get(index);
    }

    public Field getDocumentField(String fieldName) {
        return this.documentFields.get(this.keywordSurrogates.getOrDefault(fieldName, fieldName));
    }

    public SpringDataComponent<SpringDataDocumentModel> getComponentInstance(String index) {
        SpringDataComponent<SpringDataDocumentModel> component = this.componentInstances.get(index);
        return component;
    }

    private Class<? extends SpringDataDocumentModel> createConcreteDocumentClass(String index) {
        String suffixedDocumentName = index + CONCRETE_DOCUMENT_IDENTIFIER;
        String normalizedDocumentName = JavaIdentifierNormalizer.normalizeJavaClassName(suffixedDocumentName);
        Class documentClass = new ByteBuddy().subclass(this.abstractDocumentClass).name(normalizedDocumentName).annotateType(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Document.class).define(INDEX_NAME, index).build()}).make().load(this.classLoader).getLoaded();
        this.indexDocumentClasses.put(index, documentClass);
        return documentClass;
    }

    private ElasticsearchRepository<? extends SpringDataDocumentModel, String> createRepositoryInstance(Class<? extends SpringDataDocumentModel> documentClass) {
        ElasticsearchEntityInformation elasticsearchEntityInformation = this.entityInformationCreator.getEntityInformation(documentClass);
        return new SimpleElasticsearchRepository(elasticsearchEntityInformation, this.elasticsearchOperations);
    }

    private void createComponentInstance(String index, ElasticsearchRepository<? extends SpringDataDocumentModel, String> repository) {
        SpringDataComponent<? extends SpringDataDocumentModel> component = new SpringDataComponent<SpringDataDocumentModel>(repository);
        this.componentInstances.put(index, component);
    }
}

