/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.json;

import com.google.common.primitives.Primitives;
import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.common.Messages;
import com.semarchy.xdi.elasticsearch.common.ReflectUtil;
import com.semarchy.xdi.elasticsearch.json.JsonSchemaParser;
import com.semarchy.xdi.elasticsearch.json.SpringDataKeyword;
import com.semarchy.xdi.elasticsearch.springdata.SpringDataDocumentModel;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonDocumentInstanciator {
    private String packageName = "";
    private Constructor<? extends SpringDataDocumentModel> documentConstructor;
    private Map<String, Class<?>> arraysTypes;
    private final Map<Class<?>, Map<String, String>> fieldsElasticJava;
    private Deque<String> fieldNames = new ArrayDeque<String>();
    private Map<Class<?>, Map<String, Class<?>>> classFieldsTypes = new HashMap();
    private Deque<Integer> levels = new ArrayDeque<Integer>();
    private Map<String, Constructor<?>> constructors = new HashMap();
    private boolean isRoot = true;
    private JsonParser.Event event;
    private static final Class<String> STRING_TYPE = String.class;
    private static final Class<Number> NUMBER_TYPE = Number.class;
    private static final Class<Boolean> BOOLEAN_TYPE = Boolean.class;
    public static final int ROOT_LEVEL = 0;
    public static final int DOCUMENT_FIELDS_LEVEL = 1;

    public JsonDocumentInstanciator(Constructor<? extends SpringDataDocumentModel> documentConstructor, JsonSchemaParser jsonSchemaParser) {
        this.documentConstructor = documentConstructor;
        this.arraysTypes = jsonSchemaParser.getArraysTypes();
        this.fieldsElasticJava = jsonSchemaParser.getFieldsElasticJava();
    }

    public SpringDataDocumentModel instanciate(JsonParser jsonParser, JsonParser.Event rootStartEvent) throws ElasticSearchException {
        this.levels.clear();
        this.levels.add(0);
        this.fieldNames.clear();
        SpringDataDocumentModel document = null;
        try {
            document = this.documentConstructor.newInstance(new Object[0]);
            this.isRoot = true;
            this.event = rootStartEvent;
            this.set(jsonParser, document);
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
        return document;
    }

    private void set(JsonParser jsonParser, Object object) throws ElasticSearchException {
        boolean isArray = ReflectUtil.implement(List.class, object);
        List array = null;
        Class<?> fieldsClass = ReflectUtil.getFieldsClass(object);
        Map<String, Class<?>> fieldsTypes = ReflectUtil.getFieldsTypes(fieldsClass);
        if (isArray) {
            array = (List)object;
        } else if (!this.classFieldsTypes.containsKey(fieldsClass)) {
            this.classFieldsTypes.put(fieldsClass, fieldsTypes);
        }
        boolean end = false;
        while (!end) {
            if (this.isRoot) {
                this.isRoot = false;
            } else {
                this.event = jsonParser.next();
            }
            switch (this.event) {
                case START_OBJECT: {
                    this.setStartObject(isArray, array, fieldsClass, object, jsonParser);
                    break;
                }
                case END_OBJECT: {
                    int level = this.levels.removeLast();
                    this.levels.add(--level);
                    end = true;
                    break;
                }
                case KEY_NAME: {
                    this.setKey(fieldsClass, object, jsonParser);
                    break;
                }
                case VALUE_FALSE: {
                    this.setFalse(isArray, array, fieldsClass, object);
                    break;
                }
                case VALUE_TRUE: {
                    this.setTrue(isArray, array, fieldsClass, object);
                    break;
                }
                case VALUE_NUMBER: {
                    this.setNumber(isArray, array, fieldsClass, object, jsonParser);
                    break;
                }
                case VALUE_STRING: {
                    this.setString(isArray, array, fieldsClass, object, jsonParser);
                    break;
                }
                case END_ARRAY: {
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    this.setStartArray(isArray, array, fieldsClass, object, jsonParser);
                    break;
                }
                case VALUE_NULL: {
                    this.setNull(isArray, array, fieldsClass, object);
                }
            }
        }
    }

    private void setStartObject(boolean isArray, List<Object> array, Class<?> fieldsClass, Object object, JsonParser jsonParser) throws ElasticSearchException {
        int level = this.levels.removeLast();
        this.levels.add(++level);
        if (1 < level) {
            Object innerObject = null;
            try {
                if (isArray) {
                    this.levels.add(1);
                    this.fieldNames.add("items");
                    String innerObjectName = this.packageName + String.join((CharSequence)".", this.fieldNames);
                    Constructor<?> constructor = this.constructors.getOrDefault(innerObjectName, null);
                    if (constructor == null) {
                        Class<?> innerObjectType = this.arraysTypes.get(innerObjectName);
                        constructor = innerObjectType.getConstructor(new Class[0]);
                        this.constructors.put(innerObjectName, constructor);
                    }
                    innerObject = constructor.newInstance(new Object[0]);
                    this.set(jsonParser, innerObject);
                    array.add(innerObject);
                    this.fieldNames.removeLast();
                    this.levels.removeLast();
                } else {
                    String fieldName = this.fieldNames.peekLast();
                    Class<?> fieldType = this.getAndCheckFieldType(fieldsClass, fieldName);
                    innerObject = fieldType.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.set(jsonParser, innerObject);
                    Field field = fieldsClass.getDeclaredField(fieldName);
                    field.set(object, innerObject);
                    this.fieldNames.removeLast();
                }
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
    }

    private void setKey(Class<?> fieldsClass, Object object, JsonParser jsonParser) {
        String fieldName = jsonParser.getString();
        if (ReflectUtil.extend(SpringDataDocumentModel.class, object) && SpringDataKeyword.contains(fieldName)) {
            Field[] javaFields;
            Class<?> classDocument = fieldsClass;
            Field[] fieldArray = javaFields = classDocument.getFields();
            int n = javaFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field javaField = fieldArray[n2];
                String jsonFieldName = ReflectUtil.getAnnotatedJsonFieldName(javaField);
                if (fieldName.equals(jsonFieldName)) {
                    String javaFieldName;
                    fieldName = javaFieldName = javaField.getName();
                }
                ++n2;
            }
        }
        this.fieldNames.add(fieldName);
    }

    private void setFalse(boolean isArray, List<Object> array, Class<?> fieldsClass, Object object) throws ElasticSearchException {
        if (isArray) {
            this.addPrimitiveInArray(array, BOOLEAN_TYPE, false);
        } else {
            this.setPrimitive(fieldsClass, object, BOOLEAN_TYPE, false);
        }
    }

    private void setTrue(boolean isArray, List<Object> array, Class<?> fieldsClass, Object object) throws ElasticSearchException {
        if (isArray) {
            this.addPrimitiveInArray(array, BOOLEAN_TYPE, true);
        } else {
            this.setPrimitive(fieldsClass, object, BOOLEAN_TYPE, true);
        }
    }

    private void setNumber(boolean isArray, List<Object> array, Class<?> fieldsClass, Object object, JsonParser jsonParser) throws ElasticSearchException {
        Number expectedPrimitiveValue;
        Number number = expectedPrimitiveValue = jsonParser.isIntegralNumber() ? Long.valueOf(jsonParser.getLong()) : jsonParser.getBigDecimal();
        if (isArray) {
            this.addPrimitiveInArray(array, NUMBER_TYPE, expectedPrimitiveValue);
        } else {
            this.setPrimitive(fieldsClass, object, NUMBER_TYPE, expectedPrimitiveValue);
        }
    }

    private void setString(boolean isArray, List<Object> array, Class<?> fieldsClass, Object object, JsonParser jsonParser) throws ElasticSearchException {
        String expectedPrimitiveValue = jsonParser.getString();
        if (isArray) {
            this.addPrimitiveInArray(array, STRING_TYPE, expectedPrimitiveValue);
        } else {
            this.setPrimitive(fieldsClass, object, STRING_TYPE, expectedPrimitiveValue);
        }
    }

    private void setStartArray(boolean isArray, List<Object> array, Class<?> fieldsClass, Object object, JsonParser jsonParser) throws ElasticSearchException {
        ArrayList innerArray = new ArrayList();
        if (isArray) {
            this.fieldNames.add("items");
            this.set(jsonParser, innerArray);
            array.add(innerArray);
            this.fieldNames.removeLast();
        } else {
            this.set(jsonParser, innerArray);
            String fieldName = this.fieldNames.removeLast();
            try {
                Field field = fieldsClass.getDeclaredField(fieldName);
                field.set(object, innerArray);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
    }

    private void setNull(boolean isArray, List<Object> array, Class<?> fieldsClass, Object object) throws ElasticSearchException {
        if (isArray) {
            array.add(null);
        } else {
            String fieldName = this.fieldNames.removeLast();
            this.getAndCheckFieldType(fieldsClass, fieldName);
            try {
                Field field = fieldsClass.getDeclaredField(fieldName);
                field.set(object, null);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
    }

    private void setPrimitive(Class<?> objectClass, Object object, Class<?> primitiveClass, Object primitiveValue) throws ElasticSearchException {
        Class harmonizedFieldType;
        String elasticFieldName = this.fieldNames.removeLast();
        Class<?> fieldType = this.getAndCheckFieldType(objectClass, elasticFieldName);
        Class harmonizedPrimitiveType = Primitives.wrap(primitiveClass);
        if (harmonizedPrimitiveType.equals(harmonizedFieldType = Primitives.wrap(fieldType))) {
            try {
                Map<String, String> fieldsNameElasticJava = this.fieldsElasticJava.get(objectClass);
                String javaFieldName = fieldsNameElasticJava == null ? elasticFieldName : fieldsNameElasticJava.get(elasticFieldName);
                Field field = objectClass.getDeclaredField(javaFieldName);
                field.set(object, primitiveValue);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        } else {
            throw new ElasticSearchException(String.format(Messages.getString("WRONG_TYPE"), elasticFieldName, harmonizedFieldType.getName(), harmonizedPrimitiveType.getName()));
        }
    }

    private void addPrimitiveInArray(List<Object> array, Class<?> primitiveClass, Object primitiveValue) throws ElasticSearchException {
        Class harmonizedActualType;
        String itemName = this.packageName + String.join((CharSequence)".", this.fieldNames) + "." + "items";
        Class<?> expectedType = this.arraysTypes.get(itemName);
        Class harmonizedExpectedType = Primitives.wrap(expectedType);
        if (!harmonizedExpectedType.equals(harmonizedActualType = Primitives.wrap(primitiveClass))) {
            throw new ElasticSearchException(String.format(Messages.getString("WRONG_TYPE"), this.fieldNames.peekLast(), harmonizedExpectedType.getName(), harmonizedActualType.getName()));
        }
        array.add(primitiveValue);
    }

    private Class<?> getAndCheckFieldType(Class<?> objectClass, String elasticFieldName) throws ElasticSearchException {
        Map<String, String> fieldsNameElasticJava = this.fieldsElasticJava.get(objectClass);
        String javaFieldName = fieldsNameElasticJava == null ? elasticFieldName : fieldsNameElasticJava.get(elasticFieldName);
        Class<?> fieldType = this.classFieldsTypes.get(objectClass).get(javaFieldName);
        if (fieldType == null) {
            throw new ElasticSearchException(String.format(Messages.getString("UNKNOWN_FIELD"), elasticFieldName, objectClass.getName()));
        }
        return fieldType;
    }
}

