/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.json;

import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.common.ReflectUtil;
import com.semarchy.xdi.elasticsearch.springdata.SpringDataDocumentModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonDocumentMerger {
    private static final String DECMAL_SEPARATOR = ".";
    private Class<? extends SpringDataDocumentModel> classDocument;

    public JsonDocumentMerger(Class<? extends SpringDataDocumentModel> classDocument) {
        this.classDocument = classDocument;
    }

    public SpringDataDocumentModel mergeJsonDocument(SpringDataDocumentModel originalDocument, SpringDataDocumentModel updateDocument) throws ElasticSearchException {
        Object mergedObject = JsonDocumentMerger.mergeJsonDocument(this.classDocument, originalDocument, updateDocument);
        SpringDataDocumentModel mergedDocument = (SpringDataDocumentModel)mergedObject;
        if (mergedDocument != null) {
            String id = null;
            if (updateDocument != null) {
                id = updateDocument.getId();
            }
            if (id == null && originalDocument != null) {
                id = originalDocument.getId();
            }
            mergedDocument.setId(id);
        }
        return mergedDocument;
    }

    private static Object mergeJsonDocument(Class<?> classObject, Object originalObject, Object updateObject) throws ElasticSearchException {
        Object mergedObject = null;
        if (originalObject != null || updateObject != null) {
            mergedObject = originalObject == null ? updateObject : (updateObject == null ? originalObject : (Boolean.class.equals(classObject) || String.class.equals(classObject) ? updateObject : (ReflectUtil.extend(Number.class, classObject) ? JsonDocumentMerger.mergeJsonDocumentNumber(updateObject) : (ReflectUtil.implement(List.class, classObject) ? JsonDocumentMerger.mergeJsonDocumentArray(originalObject, updateObject) : JsonDocumentMerger.mergeJsonDocumentObject(classObject, originalObject, updateObject)))));
        }
        return mergedObject;
    }

    private static Object mergeJsonDocumentNumber(Object updateObject) {
        String stringNumber = updateObject.toString();
        return stringNumber.contains(DECMAL_SEPARATOR) ? new BigDecimal(stringNumber) : Long.valueOf(stringNumber);
    }

    private static Object mergeJsonDocumentArray(Object originalObject, Object updateObject) throws ElasticSearchException {
        List originalList = (List)originalObject;
        List updateList = (List)updateObject;
        int originalSize = originalList.size();
        int updateSize = updateList.size();
        int minimalSize = Math.min(originalSize, updateSize);
        ArrayList<Object> mergedList = new ArrayList<Object>(minimalSize);
        Class<?> classElement = null;
        int elementIndex = 0;
        while (elementIndex < minimalSize) {
            Object originalElement = originalList.get(elementIndex);
            Object updateElement = updateList.get(elementIndex);
            if (classElement == null) {
                if (originalElement != null) {
                    classElement = originalElement.getClass();
                } else if (updateElement != null) {
                    classElement = updateElement.getClass();
                }
            }
            Object mergedElement = JsonDocumentMerger.mergeJsonDocument(classElement, originalElement, updateElement);
            mergedList.add(mergedElement);
            ++elementIndex;
        }
        return mergedList;
    }

    private static Object mergeJsonDocumentObject(Class<?> classObject, Object originalObject, Object updateObject) throws ElasticSearchException {
        Map<String, Object> originalValues = ReflectUtil.getFieldsValues(originalObject);
        Map<String, Object> updateValues = ReflectUtil.getFieldsValues(updateObject);
        Field[] fields = classObject.getFields();
        Object mergedObject = null;
        try {
            Constructor<?> constructor = classObject.getConstructor(new Class[0]);
            mergedObject = constructor.newInstance(new Object[0]);
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                String name = field.getName();
                Class<?> fieldClass = field.getType();
                Object originalValue = originalValues.getOrDefault(name, null);
                Object updateValue = updateValues.getOrDefault(name, null);
                Object mergedValue = JsonDocumentMerger.mergeJsonDocument(fieldClass, originalValue, updateValue);
                field.set(mergedObject, mergedValue);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
        return mergedObject;
    }
}

