/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.springdata;

import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.common.Messages;
import com.semarchy.xdi.elasticsearch.springdata.SpringDataDocumentModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;

public class SpringDataComponent<T extends SpringDataDocumentModel> {
    private ElasticsearchRepository<T, String> repository;

    private boolean exists(String id) {
        return this.repository.existsById((Object)id);
    }

    public SpringDataComponent(ElasticsearchRepository<T, String> repository) {
        this.repository = repository;
    }

    public List<String> insert(List<T> documents) throws ElasticSearchException {
        ArrayList<String> ids = new ArrayList<String>();
        for (SpringDataDocumentModel document : documents) {
            String id = document.getId();
            if (id == null || !this.exists(id)) continue;
            throw new ElasticSearchException(Messages.formatIdFound(id));
        }
        Iterable resultDocuments = this.repository.saveAll(documents);
        for (SpringDataDocumentModel document : resultDocuments) {
            ids.add(document.getId());
        }
        return ids;
    }

    public List<T> get(List<String> ids) {
        ArrayList<SpringDataDocumentModel> documents = new ArrayList<SpringDataDocumentModel>();
        Iterable resultDocuments = this.repository.findAllById(ids);
        for (SpringDataDocumentModel document : resultDocuments) {
            documents.add(document);
        }
        return documents;
    }

    public void update(List<T> documents) throws ElasticSearchException {
        for (SpringDataDocumentModel document : documents) {
            String id = document.getId();
            if (id != null && this.exists(id)) continue;
            throw new ElasticSearchException(Messages.formatIdNotFound(id));
        }
        this.repository.saveAll(documents);
    }

    public Map<String, Boolean> upsert(List<T> documents) {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        HashSet<String> updated = new HashSet<String>();
        for (SpringDataDocumentModel document : documents) {
            String id = document.getId();
            if (id == null || !this.exists(id)) continue;
            updated.add(id);
        }
        Iterable newDocuments = this.repository.saveAll(documents);
        for (SpringDataDocumentModel document : newDocuments) {
            String id = document.getId();
            result.put(id, updated.contains(id));
        }
        return result;
    }

    public Map<String, Boolean> delete(List<String> ids) {
        LinkedHashMap<String, Boolean> deleted = new LinkedHashMap<String, Boolean>();
        ArrayList<String> deletedIds = new ArrayList<String>();
        for (String id : ids) {
            deletedIds.add(id);
            deleted.put(id, this.exists(id));
        }
        this.repository.deleteAllById(deletedIds);
        return deleted;
    }
}

