/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.kafka;

import com.semarchy.xdi.component.kafka.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class KafkaAdminClient
implements AutoCloseable {
    AdminClient client;

    public KafkaAdminClient(Properties properties) {
        this.client = AdminClient.create((Properties)properties);
    }

    public Map<TopicPartition, OffsetAndMetadata> resetOffsets(String consumerGroupName, List<String> topicNames, List<Integer> partitionsIds, String resetMode, Long shiftBy) throws EngineExceptionI {
        try {
            HashMap<TopicPartition, OffsetAndMetadata> newOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            Map<TopicPartition, OffsetAndMetadata> currentOffsets = ((Map)this.client.listConsumerGroupOffsets(consumerGroupName).partitionsToOffsetAndMetadata(consumerGroupName).get()).entrySet().stream().filter(entry -> topicNames.contains(((TopicPartition)entry.getKey()).topic())).filter(entry -> {
                if (partitionsIds.isEmpty()) {
                    return true;
                }
                return partitionsIds.contains(((TopicPartition)entry.getKey()).partition());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap<TopicPartition, OffsetSpec> topicPartitionOffsets = new HashMap<TopicPartition, OffsetSpec>();
            switch (resetMode) {
                case "To Latest": {
                    this.getNewOffsetsWithSpecification(newOffsets, currentOffsets, this.client, topicPartitionOffsets, OffsetSpec.latest());
                    break;
                }
                case "To Earliest": {
                    this.getNewOffsetsWithSpecification(newOffsets, currentOffsets, this.client, topicPartitionOffsets, OffsetSpec.earliest());
                    break;
                }
                case "Shift By": {
                    for (Map.Entry<TopicPartition, OffsetAndMetadata> entry2 : currentOffsets.entrySet()) {
                        Long newOffset = entry2.getValue().offset() + shiftBy;
                        newOffsets.put(entry2.getKey(), new OffsetAndMetadata(newOffset.longValue(), entry2.getValue().metadata()));
                    }
                    break;
                }
                default: {
                    this.getNewOffsetsWithSpecification(newOffsets, currentOffsets, this.client, topicPartitionOffsets, OffsetSpec.earliest());
                }
            }
            this.client.alterConsumerGroupOffsets(consumerGroupName, newOffsets).all().get();
            return newOffsets;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EngineExceptionI(String.format(Messages.getString("KafkaResetOffsetsAction.1"), e));
        }
        catch (Exception e) {
            throw new EngineExceptionI(String.format(Messages.getString("KafkaResetOffsetsAction.1"), e));
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private void getNewOffsetsWithSpecification(Map<TopicPartition, OffsetAndMetadata> newOffsets, Map<TopicPartition, OffsetAndMetadata> currentOffsets, AdminClient client, Map<TopicPartition, OffsetSpec> topicPartitionOffsets, OffsetSpec specification) throws InterruptedException, ExecutionException {
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : currentOffsets.entrySet()) {
            topicPartitionOffsets.put(entry.getKey(), specification);
        }
        ((Map)client.listOffsets(topicPartitionOffsets).all().get()).forEach((topicPartition, listOffsetResult) -> {
            OffsetAndMetadata offsetAndMetadata = newOffsets.put((TopicPartition)topicPartition, new OffsetAndMetadata(listOffsetResult.offset(), ((OffsetAndMetadata)currentOffsets.get(topicPartition)).metadata()));
        });
    }
}

