/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.kafka.consumer.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.indy.engine.action.common.SecretValueImpl;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.common.tools.impl.JavaObjectHandler;
import com.indy.engine.common.tools.impl.JavaRealObjectHandler;
import com.indy.engine.core.ISecretService;
import com.indy.engine.core.UtilsService;
import com.indy.runtime.hierarchy.IXMLConverter;
import com.indy.runtime.json.IDeferedSerialization;
import com.indy.runtime.json.IIterativeValue;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.avro.reader.AvroToHierarchyEventReader;
import com.stambia.avro.reader.visitor.AvroXMLConverter;
import com.stambia.kafka.consumer.KafkaConsumerExchange;
import com.stambia.kafka.consumer.KafkaConsumerMetaData;
import com.stambia.kafka.consumer.impl.Messages;
import com.stambia.kafka.producer.KafkaTopicMetaData;
import com.stambia.kafka.producer.impl.KafkaTopicInvokerImpl;
import com.stambia.kafka.producer.impl.XMLEventAdapter;
import com.stambia.kafka.tools.ContextClassLoaderExecutor;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.collections.map.HashedMap;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongSerializer;

public class KafkaConsumerImpl
implements JavaRealObjectHandler<KafkaConsumerExchange, KafkaConsumerMetaData> {
    private Properties props;
    private KafkaConsumer consumer;
    private KafkaProducer errorHandlerProducer;
    private DeserializerHandler valueHandler;
    private DeserializerHandler keyHandler;
    private Properties errorHandlerProps;
    private ParsedSchema keySchema;
    private ObjectMapper mapper;
    private ParsedSchema valueSchema;
    long readTimeout;
    long readMaxPollCalls;
    long pollTimeout;
    Map<String, Deserializer> headerDeserializers = new HashedMap();
    ClassLoader originClassLoader;
    UnaryOperator<String> resolveExtValue = t -> {
        try {
            return new SecretValueImpl(t, arg_0 -> ((ISecretService)UtilsService.getSecretService()).decryptString(arg_0), arg_0 -> ((ISecretService)UtilsService.getSecretService()).encryptString(arg_0)).resolveStringSecretValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    };

    public KafkaConsumerImpl() {
        this.mapper = new ObjectMapper();
    }

    public int batchSize() {
        return 1;
    }

    private void handleDeserializationError(ConsumerRecord record, DeserializerHandler.DesObject key, DeserializerHandler.DesObject value, KafkaConsumerMetaData metadata) throws InterruptedException, ExecutionException {
        String headerPrefix = metadata.techHeaderPrefix;
        if (headerPrefix == null) {
            headerPrefix = "xdi";
        }
        if (metadata.errorTopic != null) {
            if (this.errorHandlerProducer == null) {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.errorHandlerProducer = new KafkaProducer(this.errorHandlerProps);
            }
            ArrayList<Header> list = new ArrayList<Header>();
            if (value != null && value.getException() != null) {
                list.add(new StringHeader(headerPrefix + "ValueErrorMessage", value.getException().getMessage()));
            }
            if (key != null && key.getException() != null) {
                list.add(new StringHeader(headerPrefix + "KeyErrorMessage", key.getException().getMessage()));
            }
            if (metadata.techHeaderAsString.booleanValue()) {
                list.add(new StringHeader(headerPrefix + "OriginalOffset", String.valueOf(record.offset())));
                list.add(new StringHeader(headerPrefix + "OriginalPartition", String.valueOf(record.partition())));
            } else {
                list.add(new StringHeader(headerPrefix + "OriginalOffset", record.offset()));
                list.add(new StringHeader(headerPrefix + "OriginalPartition", record.partition()));
            }
            list.add(new StringHeader(headerPrefix + "OriginalTopic", record.topic()));
            for (Header header : record.headers()) {
                list.add(header);
            }
            ProducerRecord errorRecord = new ProducerRecord(metadata.errorTopic.topicName, null, (Object)(key != null ? key.getData() : null), (Object)(value != null ? value.getData() : null), list);
            Iterator iterator = (RecordMetadata)this.errorHandlerProducer.send(errorRecord).get();
        }
    }

    private Object getValue(Object value, KafkaTopicMetaData.ContentType contentType) throws Exception {
        if (value != null) {
            if (contentType == KafkaTopicMetaData.ContentType.avro) {
                XMLEventAdapter adapter = new XMLEventAdapter();
                AvroToHierarchyEventReader ather = new AvroToHierarchyEventReader();
                ather.visitRecord((GenericRecord)value);
                XMLEventReader reader = ather.creatXMLEventReader((IXMLConverter)AvroXMLConverter.INSTANCE);
                while (reader.hasNext()) {
                    adapter.add(reader.nextEvent());
                }
                return adapter;
            }
            if (contentType == KafkaTopicMetaData.ContentType.json) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (value instanceof Map || value instanceof ArrayList) {
                    map.put("root", value);
                } else {
                    map.put("e", value);
                }
                return map;
            }
        }
        return value;
    }

    public void handleObject(KafkaConsumerExchange exchange, KafkaConsumerMetaData metadata, OutputStreamTransformer.StatisticHandler sh) throws Exception {
        this.valueHandler = new DeserializerHandler(this.props, "value.deserializer", metadata.topic.topicName, this.valueSchema, false);
        this.keyHandler = new DeserializerHandler(this.props, "key.deserializer", metadata.topic.topicName, this.keySchema, true);
        new ContextClassLoaderExecutor<Void>(){

            @Override
            public Void doExecute() throws Exception {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                KafkaConsumerImpl.this.consumer = new KafkaConsumer(KafkaConsumerImpl.this.props, (Deserializer)KafkaConsumerImpl.this.keyHandler, (Deserializer)KafkaConsumerImpl.this.valueHandler);
                return null;
            }
        }.execute(this.getClass().getClassLoader());
        this.consumer.subscribe(Arrays.asList(metadata.topic.topicName));
        exchange.setTopics(this.createMessageIterator(metadata, sh));
    }

    Iterator<KafkaConsumerExchange.Message> createMessageIterator(KafkaConsumerMetaData metadata, OutputStreamTransformer.StatisticHandler sh) {
        return new ConsumeIterator(sh, metadata);
    }

    public void close() throws Exception {
        try {
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            if (this.errorHandlerProducer != null) {
                this.errorHandlerProducer.close();
                this.errorHandlerProducer = null;
            }
            if (this.keyHandler != null) {
                this.keyHandler.close();
            }
            if (this.valueHandler != null) {
                this.valueHandler.close();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originClassLoader);
        }
    }

    public void init(KafkaConsumerMetaData metadata, JavaObjectHandler.InitHandler iHandler) throws Exception {
        this.originClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
        this.errorHandlerProps = new Properties();
        this.props = new Properties();
        String serverProps = (String)this.resolveExtValue.apply(metadata.serverProperties.replace("\\", "\\\\"));
        String producerProps = (String)this.resolveExtValue.apply(metadata.consumerProperties.replace("\\", "\\\\"));
        this.props.load(new ByteArrayInputStream(serverProps.getBytes()));
        this.props.load(new ByteArrayInputStream(producerProps.getBytes()));
        if (this.props.get("bootstrap.servers") == null || ((String)this.props.get("bootstrap.servers")).isEmpty()) {
            throw new EngineExceptionI(Messages.getString("KafkaConsumerImpl.0"));
        }
        this.props.put("group.id", metadata.groupName);
        this.props.put("auto.offset.reset", "earliest");
        this.props.put("enable.auto.commit", "false");
        if (metadata.topic != null && metadata.topic.value != null && metadata.topic.value.deserializer != null && !metadata.topic.value.deserializer.isEmpty()) {
            this.props.put("value.deserializer", metadata.topic.value.deserializer);
        } else {
            this.props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        }
        if (metadata.topic != null && metadata.topic.key != null && metadata.topic.key.deserializer != null && !metadata.topic.key.deserializer.isEmpty()) {
            this.props.put("key.deserializer", metadata.topic.key.deserializer);
        } else {
            this.props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        }
        this.errorHandlerProps.putAll((Map<?, ?>)this.props);
        this.errorHandlerProps.put("key.serializer", ByteArraySerializer.class.getName());
        this.errorHandlerProps.put("value.serializer", ByteArraySerializer.class.getName());
        if (metadata.topic != null && metadata.topic.value != null) {
            this.valueSchema = KafkaTopicInvokerImpl.getSchema(metadata.topic.value, this.mapper);
        }
        if (metadata.topic != null && metadata.topic.key != null) {
            this.keySchema = KafkaTopicInvokerImpl.getSchema(metadata.topic.key, this.mapper);
        }
        this.readTimeout = metadata.readTimeout == null || metadata.readTimeout.longValue() < 0L ? -1L : metadata.readTimeout.longValue();
        this.readMaxPollCalls = metadata.readMaxPollCalls == null || metadata.readMaxPollCalls.longValue() < 0L ? -1L : metadata.readMaxPollCalls.longValue();
        this.pollTimeout = metadata.pollTimeout == null ? 1000L : metadata.pollTimeout.longValue();
        if (metadata.topic.headers != null) {
            for (Map.Entry entry : metadata.topic.headers.entrySet()) {
                this.headerDeserializers.put((String)entry.getKey(), (Deserializer)Class.forName(((KafkaTopicMetaData.Field)entry.getValue()).deserializer).newInstance());
            }
        }
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(AdminClient.class.getClassLoader());
        AdminClient adc = null;
        try {
            adc = AdminClient.create((Properties)this.props);
            adc.describeCluster().clusterId().get();
        }
        finally {
            if (adc != null) {
                adc.close();
            }
            Thread.currentThread().setContextClassLoader(threadClassLoader);
        }
    }

    class ConsumeIterator
    implements Iterator<KafkaConsumerExchange.Message>,
    Closeable,
    IIterativeValue,
    IDeferedSerialization {
        Iterator<ConsumerRecord> wrapped;
        long startMillis = 0L;
        boolean lastPoll;
        long count = 1L;
        boolean end;
        OutputStreamTransformer.StatisticHandler sh;
        KafkaConsumerMetaData metadata;

        public ConsumeIterator(OutputStreamTransformer.StatisticHandler sh, KafkaConsumerMetaData metadata) {
            this.sh = sh;
            this.metadata = metadata;
        }

        @Override
        public KafkaConsumerExchange.Message next() {
            if (this.end) {
                return null;
            }
            if (this.wrapped == null && !this.hasNext()) {
                return null;
            }
            try {
                DeserializerHandler.DesObject key;
                DeserializerHandler.DesObject value;
                boolean error = false;
                ConsumerRecord record = this.wrapped.next();
                KafkaConsumerExchange.Message message = new KafkaConsumerExchange.Message();
                message.offset = record.offset();
                message.partition = record.partition();
                message.topic = record.topic();
                message.group = this.metadata.groupName;
                message.timestamp = record.timestamp();
                if (KafkaConsumerImpl.this.readTimeout == -1L && KafkaConsumerImpl.this.readMaxPollCalls == -1L && message.timestamp > this.startMillis) {
                    this.lastPoll = true;
                }
                if ((value = (DeserializerHandler.DesObject)record.value()) != null) {
                    if (value.getException() != null) {
                        error = true;
                        message.valueErrorMessage = value.getException().getMessage();
                    } else {
                        message.value = KafkaConsumerImpl.this.getValue(value.getValue(), this.metadata.topic.value.contentType);
                    }
                }
                if ((key = (DeserializerHandler.DesObject)record.key()) != null) {
                    if (key.getException() != null) {
                        error = true;
                        message.keyErrorMessage = key.getException().getMessage();
                    } else {
                        message.key = KafkaConsumerImpl.this.getValue(key.getValue(), this.metadata.topic.key.contentType);
                    }
                }
                if (record.headers() != null) {
                    for (Header header : record.headers()) {
                        Deserializer deser = KafkaConsumerImpl.this.headerDeserializers.get(header.key());
                        if (deser == null) continue;
                        if (message.headers == null) {
                            message.headers = new HashedMap();
                        }
                        message.headers.put(header.key(), deser.deserialize(record.topic(), header.value()));
                    }
                }
                if (error) {
                    KafkaConsumerImpl.this.handleDeserializationError(record, key, value, this.metadata);
                    this.sh.handle("KAFKA_CONSUME_ERROR", 1L);
                } else {
                    this.sh.handle("KAFKA_CONSUME", 1L);
                }
                return message;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Iterator<ConsumerRecord> _nexPoll() {
            Iterator ret = null;
            boolean stop = false;
            while (!stop) {
                if (KafkaConsumerImpl.this.readMaxPollCalls > -1L) {
                    boolean b;
                    boolean bl = b = KafkaConsumerImpl.this.readMaxPollCalls >= 0L && this.count >= KafkaConsumerImpl.this.readMaxPollCalls;
                    if (b) {
                        stop = true;
                        break;
                    }
                }
                long nextTimeout = 0L;
                nextTimeout = KafkaConsumerImpl.this.readTimeout > -1L ? KafkaConsumerImpl.this.readTimeout - (System.currentTimeMillis() - this.startMillis) : KafkaConsumerImpl.this.pollTimeout;
                if (nextTimeout < 0L) {
                    stop = true;
                    break;
                }
                if (nextTimeout < KafkaConsumerImpl.this.pollTimeout) {
                    nextTimeout = KafkaConsumerImpl.this.pollTimeout;
                }
                this.sh.handle("KAFKA_POLL", 1L);
                ConsumerRecords records = KafkaConsumerImpl.this.consumer.poll(Duration.ofMillis(nextTimeout));
                ret = records.iterator();
                if (ret.hasNext()) {
                    stop = true;
                } else {
                    ret = null;
                    stop = KafkaConsumerImpl.this.readMaxPollCalls == -1L && KafkaConsumerImpl.this.readTimeout == -1L;
                }
                ++this.count;
            }
            return ret;
        }

        @Override
        public boolean hasNext() {
            if (this.startMillis == 0L) {
                this.startMillis = System.currentTimeMillis();
            }
            if (this.end) {
                return false;
            }
            if (this.wrapped == null || !this.wrapped.hasNext()) {
                this.wrapped = null;
                if (!this.lastPoll) {
                    this.wrapped = this._nexPoll();
                }
            }
            if (this.wrapped != null) {
                return true;
            }
            this.end = true;
            KafkaConsumerImpl.this.consumer.commitSync();
            this.sh.handle("KAFKA_CONSUME", 0L);
            this.wrapped = null;
            return false;
        }

        @Override
        public void close() throws IOException {
            try {
                KafkaConsumerImpl.this.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    class DeserializerHandler
    implements Deserializer {
        Deserializer wrapped;
        ParsedSchema schema;
        int version;
        String subject;
        private int schemaId;
        SchemaRegistryClient schemaRegistry;
        Map<Integer, List<String>> compatibleSchemas = new HashMap<Integer, List<String>>();
        Map<Integer, Integer> subjetVersionToSchemaVersion = new HashMap<Integer, Integer>();
        Map<Integer, ParsedSchema> cache = new HashMap<Integer, ParsedSchema>();
        protected static final byte MAGIC_BYTE = 0;

        public DeserializerHandler(Properties props, String propName, String topicName, ParsedSchema schema, boolean isKey) throws Exception {
            ConsumerConfig config = new ConsumerConfig(props);
            this.wrapped = (Deserializer)config.getConfiguredInstance(propName, Deserializer.class);
            this.wrapped.configure(config.originals(), false);
            if (this.wrapped instanceof AbstractKafkaSchemaSerDe) {
                Field field = AbstractKafkaSchemaSerDe.class.getDeclaredField("schemaRegistry");
                field.setAccessible(true);
                this.schemaRegistry = (SchemaRegistryClient)field.get(this.wrapped);
                if (this.schemaRegistry != null) {
                    this.schema = schema;
                    this.subject = isKey ? topicName + "-key" : topicName + "-value";
                    this.version = this.schemaRegistry.getVersion(this.subject, schema);
                    this.schemaId = this.schemaRegistry.getId(this.subject, schema);
                    this.schema = this.schemaRegistry.getSchemaById(this.schemaId);
                }
            }
        }

        public Object deserialize(String topic, byte[] data) {
            DesObject ret = new DesObject();
            ret.setData(data);
            ret.setTopic(topic);
            if (this.wrapped != null) {
                try {
                    if (this.schema != null) {
                        ParsedSchema _schema;
                        if (data.length < 5) {
                            throw new SerializationException(Messages.getString("KafkaConsumerImpl.2"));
                        }
                        ByteBuffer buffer = ByteBuffer.wrap(Arrays.copyOf(data, 5));
                        if (buffer.get() != 0) {
                            throw new SerializationException(Messages.getString("KafkaConsumerImpl.3"));
                        }
                        int schemaId = buffer.getInt();
                        List<Object> compatible = this.compatibleSchemas.get(schemaId);
                        if (compatible == null && (_schema = this.cache.get(schemaId)) == null) {
                            ParsedSchema schema = this.schemaRegistry.getSchemaById(schemaId);
                            this.cache.put(schemaId, schema);
                            ArrayList<ParsedSchema> list = new ArrayList<ParsedSchema>();
                            list.add(this.schema);
                            compatible = schemaId == this.schemaId ? Collections.emptyList() : (schemaId > this.schemaId ? schema.isBackwardCompatible(this.schema) : this.schema.isBackwardCompatible(schema));
                            this.compatibleSchemas.put(schemaId, compatible);
                        }
                        if (compatible != null && !compatible.isEmpty()) {
                            ret.setException(new Exception(MessageFormat.format(Messages.getString("KafkaConsumerImpl.4"), schemaId, this.subject, this.version, compatible.stream().collect(Collectors.joining(", ")))));
                            return ret;
                        }
                    }
                    ret.setValue(this.wrapped.deserialize(topic, data));
                    return ret;
                }
                catch (Exception e) {
                    ret.setException(e);
                    return ret;
                }
            }
            ret.setValue(data);
            return ret;
        }

        class DesObject {
            private byte[] data;
            private Object value;
            private Exception exception;
            private String topic;

            DesObject() {
            }

            byte[] getData() {
                return this.data;
            }

            void setData(byte[] data) {
                this.data = data;
            }

            Object getValue() {
                return this.value;
            }

            void setValue(Object value) {
                this.value = value;
            }

            Exception getException() {
                return this.exception;
            }

            void setException(Exception exception) {
                this.exception = exception;
            }

            String getTopic() {
                return this.topic;
            }

            void setTopic(String topic) {
                this.topic = topic;
            }
        }
    }

    class FF
    extends AbstractKafkaSchemaSerDe {
        FF() {
        }

        protected ByteBuffer getByteBuffer(byte[] payload) {
            ByteBuffer buffer = ByteBuffer.wrap(payload);
            if (buffer.get() != 0) {
                throw new SerializationException(Messages.getString("KafkaConsumerImpl.1"));
            }
            return buffer;
        }
    }

    class StringHeader
    implements Header {
        String key;
        LongSerializer longSerializer = new LongSerializer();
        IntegerSerializer integerSerializer = new IntegerSerializer();
        byte[] value;

        public StringHeader(String key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public StringHeader(String key, String str) {
            this.key = key;
            try {
                this.value = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public StringHeader(String key, Long str) {
            this.key = key;
            this.value = this.longSerializer.serialize(key, str);
        }

        public StringHeader(String key, Integer str) {
            this.key = key;
            this.value = this.integerSerializer.serialize(key, str);
        }

        public String key() {
            return this.key;
        }

        public byte[] value() {
            return this.value;
        }
    }
}

