/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.kafka.producer.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.indy.engine.action.common.SecretValueImpl;
import com.indy.engine.core.IJsonUtils;
import com.indy.engine.core.ISecretService;
import com.indy.engine.core.UtilsService;
import com.indy.runtime.hierarchy.IXMLConverter;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.avro.reader.visitor.AvroXMLConverter;
import com.stambia.avro.writer.AvroHierarchyEventWriter;
import com.stambia.kafka.producer.KafkaProducerMetaData;
import com.stambia.kafka.producer.KafkaTopicExchange;
import com.stambia.kafka.producer.KafkaTopicMetaData;
import com.stambia.kafka.producer.impl.Messages;
import com.stambia.kafka.tools.ContextClassLoaderExecutor;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.function.UnaryOperator;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.commons.collections.map.HashedMap;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTopicInvokerImpl {
    private Logger consoleLogger;
    private Logger actionCodeLogger;
    private KafkaProducerMetaData wsMetadata;
    private ObjectMapper mapper;
    private Properties props;
    Map<String, Serializer> headerSerializers = new HashedMap();
    long success = 0L;
    long error = 0L;
    private ParsedSchema valueSchema;
    private ParsedSchema keySchema;
    JsonSchema js;
    private KafkaProducer<Object, Object> producer;
    UnaryOperator<String> resolveExtValue = t -> {
        try {
            return new SecretValueImpl(t, arg_0 -> ((ISecretService)UtilsService.getSecretService()).decryptString(arg_0), arg_0 -> ((ISecretService)UtilsService.getSecretService()).encryptString(arg_0)).resolveStringSecretValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    };

    public KafkaTopicInvokerImpl(KafkaProducerMetaData metadata, Logger consoleLogger, Logger actionCodeLogger) throws Exception {
        this.wsMetadata = metadata;
        this.consoleLogger = consoleLogger;
        this.actionCodeLogger = actionCodeLogger;
        this.mapper = new ObjectMapper();
        this.props = new Properties();
        String serverProps = (String)this.resolveExtValue.apply(metadata.serverProperties.replace("\\", "\\\\"));
        String producerProps = (String)this.resolveExtValue.apply(metadata.producerProperties.replace("\\", "\\\\"));
        this.props.load(new ByteArrayInputStream(serverProps.getBytes()));
        this.props.load(new ByteArrayInputStream(producerProps.getBytes()));
        if (this.props.get("bootstrap.servers") == null || ((String)this.props.get("bootstrap.servers")).isEmpty()) {
            throw new EngineExceptionI(Messages.getString("KafkaTopicInvokerImpl.0"));
        }
        if (metadata.topic != null && metadata.topic.value != null) {
            if (metadata.topic.value.serializer != null && !metadata.topic.value.serializer.isEmpty()) {
                this.props.put("value.serializer", metadata.topic.value.serializer);
            } else {
                this.props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            }
        }
        if (metadata.topic != null && metadata.topic.key != null && metadata.topic.key.serializer != null && !metadata.topic.key.serializer.isEmpty()) {
            this.props.put("key.serializer", metadata.topic.key.serializer);
        } else {
            this.props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        }
        if (metadata.topic != null && metadata.topic.value != null) {
            this.valueSchema = KafkaTopicInvokerImpl.getSchema(metadata.topic.value, this.mapper);
        }
        if (metadata.topic != null && metadata.topic.key != null) {
            this.keySchema = KafkaTopicInvokerImpl.getSchema(metadata.topic.key, this.mapper);
        }
        if (metadata.topic.headers != null) {
            for (Map.Entry entry : metadata.topic.headers.entrySet()) {
                this.headerSerializers.put((String)entry.getKey(), (Serializer)Class.forName(((KafkaTopicMetaData.Field)entry.getValue()).serializer).newInstance());
            }
        }
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(AdminClient.class.getClassLoader());
        AdminClient adc = null;
        try {
            adc = AdminClient.create((Properties)this.props);
            adc.describeCluster().clusterId().get();
        }
        finally {
            if (adc != null) {
                adc.close();
            }
            Thread.currentThread().setContextClassLoader(threadClassLoader);
        }
        new ContextClassLoaderExecutor<Void>(){

            @Override
            public Void doExecute() throws Exception {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                KafkaTopicInvokerImpl.this.producer = new KafkaProducer(KafkaTopicInvokerImpl.this.props);
                return null;
            }
        }.execute(this.getClass().getClassLoader());
    }

    public static ParsedSchema getSchema(KafkaTopicMetaData.Field field, ObjectMapper mapper) throws Exception {
        if (field.schema != null && !field.schema.isEmpty()) {
            if (field.contentType == KafkaTopicMetaData.ContentType.avro) {
                return new AvroSchema(new Schema.Parser().parse(field.schema));
            }
            if (field.contentType == KafkaTopicMetaData.ContentType.json) {
                return new JsonSchema(mapper.readTree(field.schema));
            }
        }
        return null;
    }

    public KafkaTopicInvokerImpl(KafkaProducerMetaData metadata) throws Exception {
        this(metadata, LoggerFactory.getLogger((String)"com.indy.engine.console"), LoggerFactory.getLogger((String)"com.indy.engine.actionCodes"));
    }

    private Object getValue(KafkaTopicMetaData.ContentType type, IJsonUtils.Adapter xec, ParsedSchema schema, boolean byteMode, String subject) throws Exception {
        if (type == KafkaTopicMetaData.ContentType.avro) {
            if (schema == null) {
                throw new Exception(Messages.getString("KafkaTopicInvokerImpl.1"));
            }
            return this.getAvroRecord(xec, (AvroSchema)schema, byteMode, subject);
        }
        if (type == KafkaTopicMetaData.ContentType.json) {
            if (schema != null) {
                return this.getJson(xec, ((JsonSchema)schema).toJsonNode(), byteMode);
            }
            return this.getJson(xec, null, byteMode);
        }
        return null;
    }

    private Object getAvroRecord(IJsonUtils.Adapter xec, AvroSchema avroSchema, boolean byteMode, String subject) throws Exception {
        Collection col = (Collection)xec.adapt(Collection.class, null);
        Class<?> clazz = this.getClass().getClassLoader().loadClass("com.stambia.avro.writer.AvroHierarchyEventsToGenericRecord");
        final GenericRecord[] grs = new GenericRecord[1];
        AvroHierarchyEventWriter ahew = new AvroHierarchyEventWriter(avroSchema.rawSchema()){

            public void handleRecord(GenericRecord record) throws IOException {
                grs[0] = record;
            }
        };
        ahew.setDisableFirstRoot(false);
        XMLEventWriter writer = ahew.createXMLEventWriter((IXMLConverter)AvroXMLConverter.INSTANCE);
        for (XMLEvent event : col) {
            writer.add(event);
        }
        if (byteMode) {
            SpecificDatumWriter datumWriter = new SpecificDatumWriter(avroSchema.rawSchema());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BinaryEncoder binaryEncoder = new EncoderFactory().binaryEncoder((OutputStream)byteArrayOutputStream, null);
            String schemaRegistryUrl = this.props.getProperty("schema.registry.url");
            if (schemaRegistryUrl != null && !schemaRegistryUrl.equals("")) {
                int schemaId = this.getSchemaId(avroSchema, subject);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(ByteBuffer.allocate(4).putInt(schemaId).array());
            }
            datumWriter.write((Object)grs[0], (Encoder)binaryEncoder);
            binaryEncoder.flush();
            return byteArrayOutputStream.toByteArray();
        }
        return grs[0];
    }

    private int getSchemaId(AvroSchema avroSchema, String subject) throws EngineExceptionI {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CachedSchemaRegistryClient client = new CachedSchemaRegistryClient(this.props.getProperty("schema.registry.url"), 10);){
                if (this.props.get("auto.register.schemas") == null || this.props.get("auto.register.schemas") != null && this.props.get("auto.register.schemas").equals("true")) {
                    return client.registerWithResponse(subject, (ParsedSchema)avroSchema, false).getId();
                }
                if (this.props.get("use.latest.version") != null && this.props.get("use.latest.version").equals("true")) {
                    return client.getLatestSchemaMetadata(subject).getId();
                }
                return client.getId(subject, (ParsedSchema)avroSchema);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("KafkaTopicInvokerImpl.2"), (Throwable)e);
        }
    }

    private Object getJson(IJsonUtils.Adapter xec, JsonNode jsonSchema, boolean byteMode) throws Exception {
        String _str = (String)xec.adapt(String.class, null);
        JsonNode node = this.mapper.readTree(_str);
        if (jsonSchema != null) {
            return JsonSchemaUtils.envelope((JsonNode)jsonSchema, (JsonNode)node);
        }
        if (byteMode) {
            node.binaryValue();
        }
        return node;
    }

    public String handleRequest(KafkaProducerMetaData metadata, KafkaTopicExchange exchange) throws Exception {
        Object key;
        Object value;
        String subject;
        String keyTag = "-key";
        String valueTag = "-value";
        if (exchange.value instanceof IJsonUtils.Adapter) {
            subject = metadata.topic.topicName.concat("-value");
            value = metadata.topic.value.contentType == KafkaTopicMetaData.ContentType.json && metadata.topic.value.serializer != null && metadata.topic.value.serializer.equals("io.confluent.kafka.serializers.KafkaJsonSerializer") ? this.getValue(metadata.topic.value.contentType, (IJsonUtils.Adapter)exchange.value, null, false, subject) : (metadata.topic.value.contentType == KafkaTopicMetaData.ContentType.json && metadata.topic.value.serializer != null && metadata.topic.value.serializer.equals("org.apache.kafka.common.serialization.ByteArraySerializer") ? this.getValue(metadata.topic.value.contentType, (IJsonUtils.Adapter)exchange.value, null, true, subject) : (metadata.topic.value.contentType == KafkaTopicMetaData.ContentType.avro && metadata.topic.value.serializer != null && metadata.topic.value.serializer.equals("org.apache.kafka.common.serialization.ByteArraySerializer") ? this.getValue(metadata.topic.value.contentType, (IJsonUtils.Adapter)exchange.value, this.valueSchema, true, subject) : this.getValue(metadata.topic.value.contentType, (IJsonUtils.Adapter)exchange.value, this.valueSchema, false, subject)));
        } else {
            value = exchange.value;
        }
        if (exchange.key instanceof IJsonUtils.Adapter) {
            subject = metadata.topic.topicName.concat("-key");
            key = metadata.topic.key.contentType == KafkaTopicMetaData.ContentType.json && metadata.topic.key.serializer != null && metadata.topic.key.serializer.equals("io.confluent.kafka.serializers.KafkaJsonSerializer") ? this.getValue(metadata.topic.key.contentType, (IJsonUtils.Adapter)exchange.key, null, false, subject) : (metadata.topic.key.contentType == KafkaTopicMetaData.ContentType.json && metadata.topic.key.serializer != null && metadata.topic.key.serializer.equals("io.confluent.kafka.serializers.ByteArraySerializer") ? this.getValue(metadata.topic.key.contentType, (IJsonUtils.Adapter)exchange.key, null, true, subject) : this.getValue(metadata.topic.key.contentType, (IJsonUtils.Adapter)exchange.key, this.keySchema, false, subject));
        } else {
            key = exchange.key;
        }
        final ProducerRecord record = new ProducerRecord(metadata.topic.topicName, key, value);
        if (exchange.headers != null) {
            for (Map.Entry entry : exchange.headers.entrySet()) {
                Serializer ser = this.headerSerializers.get(entry.getKey());
                byte[] bytes = ser.serialize(metadata.topic.topicName, entry.getValue());
                record.headers().add((String)entry.getKey(), bytes);
            }
        }
        RecordMetadata rm = (RecordMetadata)new ContextClassLoaderExecutor<RecordMetadata>(){

            @Override
            public RecordMetadata doExecute() throws Exception {
                return (RecordMetadata)KafkaTopicInvokerImpl.this.producer.send(record).get();
            }
        }.execute(null);
        exchange.offset = rm.offset();
        exchange.partition = rm.partition();
        exchange.topic = rm.topic();
        exchange.timestamp = rm.timestamp();
        return null;
    }

    public void close() throws Exception {
        new ContextClassLoaderExecutor<Void>(){

            @Override
            public Void doExecute() throws Exception {
                KafkaTopicInvokerImpl.this.producer.close();
                return null;
            }
        }.execute(null);
    }
}

