/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.kafka.producer.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;

public class LoggerInputStream
extends FilterInputStream {
    private Logger logger;
    private Charset charset;

    public LoggerInputStream(InputStream is, Logger logger, Charset charset) {
        super(is);
        this.logger = logger;
        this.charset = charset;
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead > 0) {
            String readString = new String(Arrays.copyOfRange(b, 0, bytesRead), this.charset);
            this.logger.info(readString);
        }
        return bytesRead;
    }
}

