/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.cache.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.bindings.cache.Cache;
import org.apache.chemistry.opencmis.client.bindings.cache.CacheLevel;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheImpl
implements Cache {
    private static final Logger LOG = LoggerFactory.getLogger(CacheImpl.class);
    private static final long serialVersionUID = 1L;
    private List<Class<?>> levels;
    private List<Map<String, String>> levelParameters;
    private final String name;
    private CacheLevel root;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public CacheImpl() {
        this.name = "Cache";
    }

    public CacheImpl(String name) {
        this.name = name;
    }

    @Override
    public void initialize(String[] cacheLevelConfig) {
        if (this.levels != null) {
            throw new IllegalStateException("Cache already initialize!");
        }
        if (cacheLevelConfig == null || cacheLevelConfig.length == 0) {
            throw new IllegalArgumentException("Cache config must not be empty!");
        }
        this.lock.writeLock().lock();
        try {
            this.levels = new ArrayList(cacheLevelConfig.length);
            this.levelParameters = new ArrayList<Map<String, String>>();
            String[] stringArray = cacheLevelConfig;
            int n = cacheLevelConfig.length;
            int n2 = 0;
            while (n2 < n) {
                String config = stringArray[n2];
                int x = config.indexOf(32);
                if (x == -1) {
                    this.addLevel(config, null);
                } else {
                    this.addLevel(config.substring(0, x), config.substring(x + 1));
                }
                ++n2;
            }
            this.root = this.createCacheLevel(0);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void addLevel(String className, String parameters) {
        Class<?> clazz;
        try {
            clazz = ClassLoaderUtil.loadClass(className, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class '" + className + "' not found!", e);
        }
        if (!CacheLevel.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class '" + className + "' does not implement the CacheLevel interface!");
        }
        this.levels.add(clazz);
        if (parameters == null) {
            this.levelParameters.add(null);
        } else {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            this.levelParameters.add(parameterMap);
            String[] stringArray = parameters.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] keyValue = pair.split("=");
                if (keyValue.length == 1) {
                    parameterMap.put(keyValue[0], "");
                } else {
                    parameterMap.put(keyValue[0], keyValue[1]);
                }
                ++n2;
            }
        }
    }

    @Override
    public Object get(String ... keys) {
        if (keys == null) {
            return null;
        }
        if (this.levels.size() != keys.length) {
            throw new IllegalArgumentException("Wrong number of keys!");
        }
        Object result = null;
        this.lock.readLock().lock();
        try {
            CacheLevel cacheLevel = this.root;
            int i = 0;
            while (i < keys.length - 1) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    return null;
                }
                cacheLevel = (CacheLevel)level;
                ++i;
            }
            result = cacheLevel.get(keys[keys.length - 1]);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    @Override
    public void put(Object value, String ... keys) {
        if (keys == null) {
            return;
        }
        if (this.levels.size() != keys.length) {
            throw new IllegalArgumentException("Wrong number of keys!");
        }
        this.lock.writeLock().lock();
        try {
            CacheLevel cacheLevel = this.root;
            int i = 0;
            while (i < keys.length - 1) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    level = this.createCacheLevel(i + 1);
                    cacheLevel.put(level, keys[i]);
                }
                cacheLevel = (CacheLevel)level;
                ++i;
            }
            cacheLevel.put(value, keys[keys.length - 1]);
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: put [{}] = {}", new Object[]{this.name, CacheImpl.getFormattedKeys(keys), value});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void remove(String ... keys) {
        if (keys == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            CacheLevel cacheLevel = this.root;
            int i = 0;
            while (i < keys.length - 1) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    return;
                }
                cacheLevel = (CacheLevel)level;
                ++i;
            }
            cacheLevel.remove(keys[keys.length - 1]);
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: removed [{}]", (Object)this.name, (Object)CacheImpl.getFormattedKeys(keys));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeAll() {
        this.lock.writeLock().lock();
        try {
            this.root = this.createCacheLevel(0);
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: removed all", (Object)this.name);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int check(String ... keys) {
        if (keys == null) {
            return -1;
        }
        this.lock.readLock().lock();
        try {
            CacheLevel cacheLevel = this.root;
            int i = 0;
            while (i < keys.length - 1) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    int n = i;
                    return n;
                }
                cacheLevel = (CacheLevel)level;
                ++i;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return keys.length;
    }

    @Override
    public void writeLock() {
        this.lock.writeLock().lock();
    }

    @Override
    public void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    private CacheLevel createCacheLevel(int level) {
        if (level < 0 || level >= this.levels.size()) {
            throw new IllegalArgumentException("Cache level doesn't fit the configuration!");
        }
        Class<?> clazz = this.levels.get(level);
        CacheLevel cacheLevel = null;
        try {
            cacheLevel = (CacheLevel)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cache level problem?!", e);
        }
        cacheLevel.initialize(this.levelParameters.get(level));
        return cacheLevel;
    }

    public String toString() {
        return this.root == null ? "(no cache root)" : this.root.toString();
    }

    private static String getFormattedKeys(String[] keys) {
        assert (keys != null);
        StringBuilder sb = new StringBuilder(32);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(k);
            ++n2;
        }
        return sb.toString();
    }
}

