/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.ClientTypeCacheImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public class DiscoveryServiceImpl
extends AbstractBrowserBindingService
implements DiscoveryService {
    public DiscoveryServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    @Override
    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("query");
        formData.addParameter("statement", statement);
        formData.addParameter("searchAllVersions", searchAllVersions);
        formData.addParameter("includeAllowableActions", includeAllowableActions);
        formData.addParameter("includeRelationships", (Object)includeRelationships);
        formData.addParameter("renditionFilter", renditionFilter);
        formData.addParameter("maxItems", maxItems);
        formData.addParameter("skipCount", skipCount);
        formData.addParameter("dateTimeFormat", this.getDateTimeFormatParameter());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertObjectList(json, typeCache, true);
    }

    @Override
    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        Object token;
        UrlBuilder url = this.getRepositoryUrl(repositoryId, "contentChanges");
        url.addParameter("changeLogToken", changeLogToken == null ? null : changeLogToken.getValue());
        url.addParameter("includeProperties", includeProperties);
        url.addParameter("filter", filter);
        url.addParameter("includePolicyIds", includePolicyIds);
        url.addParameter("includeACL", includeAcl);
        url.addParameter("maxItems", maxItems);
        url.addParameter("succinct", this.getSuccinctParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        if (changeLogToken != null && json != null && (token = json.get("changeLogToken")) instanceof String) {
            changeLogToken.setValue((String)token);
        }
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjectList(json, typeCache, false);
    }
}

