/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.ClientTypeCacheImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;

public class PolicyServiceImpl
extends AbstractBrowserBindingService
implements PolicyService {
    public PolicyServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    @Override
    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("applyPolicy");
        formData.addPolicyIdParameter(policyId);
        this.postAndConsume(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
    }

    @Override
    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("removePolicy");
        formData.addPolicyIdParameter(policyId);
        this.postAndConsume(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
    }

    @Override
    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "policies");
        url.addParameter("filter", filter);
        url.addParameter("succinct", this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjects(json, typeCache);
    }
}

