/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.io.File;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.server.MutableCallContext;

public class LocalCallContext
implements MutableCallContext {
    private final Map<String, Object> contextMap = new HashMap<String, Object>();

    public LocalCallContext(String repositoryId, String user, String password) {
        this.contextMap.put("repositoryId", repositoryId);
        this.contextMap.put("username", user);
        this.contextMap.put("password", password);
    }

    public LocalCallContext(String repositoryId, String user, String password, String language, String country) {
        this(repositoryId, user, password);
        if (language != null) {
            this.put("language", language);
            this.put("locale", language);
        }
        if (country != null) {
            this.put("country", country);
            this.put("locale", language + "-" + country);
        }
    }

    @Override
    public String getBinding() {
        return "local";
    }

    @Override
    public Object get(String key) {
        return this.contextMap.get(key);
    }

    @Override
    public CmisVersion getCmisVersion() {
        return CmisVersion.CMIS_1_1;
    }

    @Override
    public String getRepositoryId() {
        return (String)this.get("repositoryId");
    }

    @Override
    public String getUsername() {
        return (String)this.get("username");
    }

    @Override
    public String getPassword() {
        return (String)this.get("password");
    }

    @Override
    public String getLocale() {
        return (String)this.get("locale");
    }

    @Override
    public BigInteger getOffset() {
        return (BigInteger)this.get("offset");
    }

    @Override
    public BigInteger getLength() {
        return (BigInteger)this.get("length");
    }

    @Override
    public boolean isObjectInfoRequired() {
        return false;
    }

    @Override
    public File getTempDirectory() {
        return null;
    }

    @Override
    public boolean encryptTempFiles() {
        return false;
    }

    @Override
    public int getMemoryThreshold() {
        return 0;
    }

    @Override
    public long getMaxContentSize() {
        return -1L;
    }

    @Override
    public void put(String key, Object value) {
        this.contextMap.put(key, value);
    }

    @Override
    public Object remove(String key) {
        return this.contextMap.remove(key);
    }
}

