/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

public class VersioningServiceImpl
extends AbstractWebServicesService
implements VersioningService {
    private final AbstractPortProvider portProvider;

    public VersioningServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    @Override
    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "checkOut");
        try {
            try {
                jakarta.xml.ws.Holder<String> portObjectId = WSConverter.convertHolder(objectId);
                jakarta.xml.ws.Holder portContentCopied = new jakarta.xml.ws.Holder();
                jakarta.xml.ws.Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
                port.checkOut(repositoryId, portObjectId, portExtension, (jakarta.xml.ws.Holder<Boolean>)portContentCopied);
                WSConverter.setHolderValue(portObjectId, objectId);
                WSConverter.setHolderValue(portContentCopied, contentCopied);
                WSConverter.setExtensionValues(portExtension, extension);
            }
            catch (CmisException e) {
                throw this.convertException(e);
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Error: " + e.getMessage(), e);
            }
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "cancelCheckOut");
        try {
            try {
                jakarta.xml.ws.Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
                port.cancelCheckOut(repositoryId, objectId, portExtension);
                WSConverter.setExtensionValues(portExtension, extension);
            }
            catch (CmisException e) {
                throw this.convertException(e);
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Error: " + e.getMessage(), e);
            }
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "checkIn");
        try {
            try {
                jakarta.xml.ws.Holder<String> portObjectId = WSConverter.convertHolder(objectId);
                jakarta.xml.ws.Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
                port.checkIn(repositoryId, portObjectId, major, WSConverter.convert(properties), WSConverter.convert(contentStream, false), checkinComment, policies, WSConverter.convert(addACEs), WSConverter.convert(removeACEs), portExtension);
                WSConverter.setHolderValue(portObjectId, objectId);
                WSConverter.setExtensionValues(portExtension, extension);
            }
            catch (CmisException e) {
                throw this.convertException(e);
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Error: " + e.getMessage(), e);
            }
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "getAllVersions");
        try {
            List<CmisObjectType> versionList = port.getAllVersions(repositoryId, versionSeriesId, filter, includeAllowableActions, WSConverter.convert(extension));
            if (versionList == null) {
                return null;
            }
            ArrayList<ObjectData> result = new ArrayList<ObjectData>();
            for (CmisObjectType version : versionList) {
                result.add(WSConverter.convert(version));
            }
            ArrayList<ObjectData> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "getObjectOfLatestVersion");
        try {
            ObjectData objectData = WSConverter.convert(port.getObjectOfLatestVersion(repositoryId, versionSeriesId, major, filter, includeAllowableActions, WSConverter.convert(EnumIncludeRelationships.class, includeRelationships), renditionFilter, includePolicyIds, includeACL, WSConverter.convert(extension)));
            return objectData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "getPropertiesOfLatestVersion");
        try {
            Properties properties = WSConverter.convert(port.getPropertiesOfLatestVersion(repositoryId, versionSeriesId, major, filter, WSConverter.convert(extension)));
            return properties;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

