/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.async;

import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.chemistry.opencmis.client.api.AsyncSession;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;

public abstract class AbstractAsyncSession
implements AsyncSession {
    protected Session session;

    public AbstractAsyncSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        this.session = session;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Future<CmisObject> getObject(ObjectId objectId) {
        return this.getObject(objectId, this.session.getDefaultContext());
    }

    @Override
    public Future<CmisObject> getObject(String objectId) {
        return this.getObject(objectId, this.session.getDefaultContext());
    }

    @Override
    public Future<CmisObject> getObjectByPath(String path) {
        return this.getObjectByPath(path, this.session.getDefaultContext());
    }

    @Override
    public Future<CmisObject> getObjectByPath(String parentPath, String name) {
        return this.getObjectByPath(parentPath, name, this.session.getDefaultContext());
    }

    @Override
    public Future<Document> getLatestDocumentVersion(ObjectId objectId) {
        return this.getLatestDocumentVersion(objectId, this.session.getDefaultContext());
    }

    @Override
    public Future<Document> getLatestDocumentVersion(ObjectId objectId, OperationContext context) {
        return this.getLatestDocumentVersion(objectId, false, context);
    }

    @Override
    public Future<Document> getLatestDocumentVersion(String objectId) {
        return this.getLatestDocumentVersion(objectId, this.session.getDefaultContext());
    }

    @Override
    public Future<Document> getLatestDocumentVersion(String objectId, OperationContext context) {
        return this.getLatestDocumentVersion(objectId, false, context);
    }

    @Override
    public Future<ObjectId> createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState) {
        return this.createDocument(properties, folderId, contentStream, versioningState, null, null, null);
    }

    @Override
    public Future<ObjectId> createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState) {
        return this.createDocumentFromSource(source, properties, folderId, versioningState, null, null, null);
    }

    @Override
    public Future<ObjectId> createFolder(Map<String, ?> properties, ObjectId folderId) {
        return this.createFolder(properties, folderId, null, null, null);
    }

    @Override
    public Future<ObjectId> createPolicy(Map<String, ?> properties, ObjectId folderId) {
        return this.createPolicy(properties, folderId, null, null, null);
    }

    @Override
    public Future<ObjectId> createItem(Map<String, ?> properties, ObjectId folderId) {
        return this.createItem(properties, folderId, null, null, null);
    }

    @Override
    public Future<ObjectId> createRelationship(Map<String, ?> properties) {
        return this.createRelationship(properties, null, null, null);
    }

    @Override
    public Future<ContentStream> getContentStream(ObjectId docId) {
        return this.getContentStream(docId, null, null, null);
    }

    @Override
    public Future<ContentStream> storeContentStream(ObjectId docId, OutputStream target) {
        return this.storeContentStream(docId, null, null, null, target);
    }

    @Override
    public Future<?> delete(ObjectId objectId) {
        return this.delete(objectId, true);
    }
}

