/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.cache.Cache;

public class CacheImpl
implements Cache {
    private static final long serialVersionUID = 1L;
    private static final float HASHTABLE_LOAD_FACTOR = 0.75f;
    private int cacheSize;
    private int cacheTtl;
    private int pathToIdSize;
    private int pathToIdTtl;
    private LinkedHashMap<String, CacheItem<Map<String, CmisObject>>> objectMap;
    private LinkedHashMap<String, CacheItem<String>> pathToIdMap;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public void initialize(Session session, Map<String, String> parameters) {
        assert (parameters != null);
        this.lock.writeLock().lock();
        try {
            try {
                this.cacheSize = Integer.valueOf(parameters.get("org.apache.chemistry.opencmis.cache.objects.size"));
                if (this.cacheSize < 0) {
                    this.cacheSize = 0;
                }
            }
            catch (Exception e) {
                this.cacheSize = 1000;
            }
            try {
                this.cacheTtl = Integer.valueOf(parameters.get("org.apache.chemistry.opencmis.cache.objects.ttl"));
                if (this.cacheTtl < 0) {
                    this.cacheTtl = 0x6DDD00;
                }
            }
            catch (Exception e) {
                this.cacheTtl = 0x6DDD00;
            }
            try {
                this.pathToIdSize = Integer.valueOf(parameters.get("org.apache.chemistry.opencmis.cache.pathtoid.size"));
                if (this.pathToIdSize < 0) {
                    this.pathToIdSize = 0;
                }
            }
            catch (Exception e) {
                this.pathToIdSize = 1000;
            }
            try {
                this.pathToIdTtl = Integer.valueOf(parameters.get("org.apache.chemistry.opencmis.cache.pathtoid.ttl"));
                if (this.pathToIdTtl < 0) {
                    this.pathToIdTtl = 1800000;
                }
            }
            catch (Exception e) {
                this.pathToIdTtl = 1800000;
            }
            this.initializeInternals();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void initializeInternals() {
        this.lock.writeLock().lock();
        try {
            int cacheHashTableCapacity = (int)Math.ceil((float)this.cacheSize / 0.75f) + 1;
            final int cs = this.cacheSize;
            this.objectMap = new LinkedHashMap<String, CacheItem<Map<String, CmisObject>>>(cacheHashTableCapacity, 0.75f){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, CacheItem<Map<String, CmisObject>>> eldest) {
                    return this.size() > cs;
                }
            };
            int pathtoidHashTableCapacity = (int)Math.ceil((float)this.pathToIdSize / 0.75f) + 1;
            final int ptis = this.pathToIdSize;
            this.pathToIdMap = new LinkedHashMap<String, CacheItem<String>>(pathtoidHashTableCapacity, 0.75f){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, CacheItem<String>> eldest) {
                    return this.size() > ptis;
                }
            };
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.initializeInternals();
    }

    @Override
    public boolean containsId(String objectId, String cacheKey) {
        this.lock.writeLock().lock();
        try {
            if (!this.objectMap.containsKey(objectId)) {
                return false;
            }
            CacheItem<Map<String, CmisObject>> item = this.objectMap.get(objectId);
            if (item.isExpired()) {
                this.objectMap.remove(objectId);
                return false;
            }
            return true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsPath(String path, String cacheKey) {
        this.lock.writeLock().lock();
        try {
            if (!this.pathToIdMap.containsKey(path)) {
                return false;
            }
            CacheItem<String> item = this.pathToIdMap.get(path);
            if (item.isExpired() || !this.containsId(item.getItem(), cacheKey)) {
                this.pathToIdMap.remove(path);
                return false;
            }
            return true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public CmisObject getById(String objectId, String cacheKey) {
        this.lock.writeLock().lock();
        try {
            if (!this.containsId(objectId, cacheKey)) {
                return null;
            }
            Map<String, CmisObject> item = this.objectMap.get(objectId).getItem();
            CmisObject cmisObject = item == null ? null : item.get(cacheKey);
            return cmisObject;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public CmisObject getByPath(String path, String cacheKey) {
        this.lock.writeLock().lock();
        try {
            if (!this.containsPath(path, cacheKey)) {
                return null;
            }
            CacheItem<String> item = this.pathToIdMap.get(path);
            CmisObject cmisObject = this.getById(item.getItem(), cacheKey);
            return cmisObject;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String getObjectIdByPath(String path) {
        this.lock.writeLock().lock();
        try {
            CacheItem<String> item = this.pathToIdMap.get(path);
            if (item == null) {
                return null;
            }
            if (item.isExpired()) {
                this.pathToIdMap.remove(path);
                return null;
            }
            String string = item.getItem();
            return string;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void put(CmisObject object, String cacheKey) {
        if (object == null || cacheKey == null) {
            return;
        }
        if (object.getId() == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            String path;
            Map<String, CmisObject> m;
            CacheItem<Map<String, CmisObject>> cacheKeyMap = this.objectMap.get(object.getId());
            if (cacheKeyMap == null) {
                cacheKeyMap = new CacheItem(new HashMap(), this.cacheTtl);
                this.objectMap.put(object.getId(), cacheKeyMap);
            }
            if ((m = cacheKeyMap.getItem()) != null) {
                m.put(cacheKey, object);
            }
            if ((path = (String)object.getPropertyValue("cmis:path")) != null) {
                this.pathToIdMap.put(path, new CacheItem<String>(object.getId(), this.pathToIdTtl));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void putPath(String path, CmisObject object, String cacheKey) {
        if (path == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.put(object, cacheKey);
            if (object != null && object.getId() != null && cacheKey != null) {
                this.pathToIdMap.put(path, new CacheItem<String>(object.getId(), this.pathToIdTtl));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void remove(String objectId) {
        if (objectId == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.objectMap.remove(objectId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removePath(String path) {
        if (path == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.pathToIdMap.remove(path);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    private static class CacheItem<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private SoftReference<T> item;
        private long timestamp;
        private int ttl;

        public CacheItem(T item, int ttl) {
            this.item = new SoftReference<T>(item);
            this.timestamp = System.currentTimeMillis();
            this.ttl = ttl;
        }

        public synchronized boolean isExpired() {
            if (this.item == null || this.item.get() == null) {
                return true;
            }
            return this.timestamp + (long)this.ttl < System.currentTimeMillis();
        }

        public synchronized T getItem() {
            if (this.isExpired()) {
                this.item = null;
                return null;
            }
            return this.item.get();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.isExpired() ? null : this.item.get());
            out.writeLong(this.timestamp);
            out.writeInt(this.ttl);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Object object = in.readObject();
            this.timestamp = in.readLong();
            this.ttl = in.readInt();
            if (object != null && this.timestamp + (long)this.ttl >= System.currentTimeMillis()) {
                this.item = new SoftReference<Object>(object);
            }
        }
    }
}

