/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.util;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractIterator;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;

public class CollectionPageIterator<T>
extends AbstractIterator<T> {
    public CollectionPageIterator(long skipCount, AbstractPageFetcher<T> pageFetcher) {
        super(skipCount, pageFetcher);
    }

    @Override
    public boolean hasNext() {
        AbstractPageFetcher.Page page = this.getCurrentPage();
        if (page == null) {
            return false;
        }
        List items = page.getItems();
        return items != null && this.getSkipOffset() < items.size();
    }

    @Override
    public T next() {
        AbstractPageFetcher.Page page = this.getCurrentPage();
        if (page == null) {
            return null;
        }
        List items = page.getItems();
        if (items == null || items.isEmpty() || this.getSkipOffset() == items.size()) {
            return null;
        }
        try {
            return items.get(this.incrementSkipOffset());
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException(e);
        }
    }
}

