/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.elasticsearch.action;

import com.indy.addons.elasticsearch.Messages;
import com.indy.addons.elasticsearch.action.ReverseDocAction;
import com.indy.addons.json.JSONReverser;
import com.indy.runtime.json.JsonUtils;
import com.semarchy.xdi.designer.core.http.ApacheHttpClient;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.xml.bind.DatatypeConverter;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class ReverseSearchAction
implements IExecute {
    private static int version = 0;
    private static final Logger logger = LogManager.getLogger(ReverseSearchAction.class);

    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode node = (MdNode)object;
        version = ReverseDocAction.getElasticsearchVersion(node);
        ReverseSearchAction.reverse(node, 0);
        return null;
    }

    public static void reverse(MdNode node, int mode) throws ExecuteException {
        ReverseSearchAction.reverse(node, mode, null);
    }

    public static List<MdNode> getReversedNodes(MdNode currentNode, int mode, String data, SSLContext sslContext) throws ExecuteException {
        try {
            String reverseFrom;
            String urlStr = currentNode.evaluate("ancestor-or-self::*/@httpUrl");
            String index = currentNode.evaluate("@indexes");
            String type = currentNode.evaluate("@types");
            String query = currentNode.evaluate("@query");
            if (urlStr == null || urlStr.isEmpty()) {
                throw new ExecuteException(Messages.ReverseSearchAction_4);
            }
            List _nodes = (List)currentNode.evaluateMdSet("*[name()='value' and @name!='response']");
            String strUrl = version >= 7 ? urlStr + "/" + index + "/_search" : urlStr + "/" + index + "/" + type + "/_search";
            String reverseSize = currentNode.evaluate("ancestor-or-self::server/@reverseSize");
            if (reverseSize != null && !reverseSize.isEmpty()) {
                strUrl = strUrl + "?size=" + reverseSize;
            }
            if ((reverseFrom = currentNode.evaluate("ancestor-or-self::server/@reverseFrom")) != null && !reverseFrom.isEmpty()) {
                strUrl = reverseSize != null && !reverseSize.isEmpty() ? strUrl + "&" : strUrl + "?";
                strUrl = strUrl + "from=" + reverseFrom;
            }
            ReverseDocAction.Credential credential = ReverseDocAction.getCredential(currentNode);
            HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
            Credentials credentials = null;
            if (credential.useApiKey) {
                String encoded = DatatypeConverter.printBase64Binary((byte[])(credential.id + ":" + credential.secret).getBytes());
                headers.put("Authorization", (CallSite)((Object)("ApiKey " + encoded)));
            } else {
                credentials = ApacheHttpClient.createBasicAuthCredentials((String)credential.id, (char[])credential.secret.toCharArray());
            }
            headers.put("Content-Type", (CallSite)ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8));
            ApacheHttpClient client = ApacheHttpClient.build((ApacheHttpClient.SslConfig)new ApacheHttpClient.SslConfig(sslContext));
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            for (MdNode o : _nodes) {
                String val = o.evaluate("@reverseValue");
                if (val == null) continue;
                String _type = o.evaluate("@type");
                if (_type != null && _type.equals("string")) {
                    inputParams.put(o.getName(), "\"" + val + "\"");
                    continue;
                }
                inputParams.put(o.getName(), val);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JsonUtils.convertJsonToXml((InputStream)new ByteArrayInputStream(query.getBytes(StandardCharsets.UTF_8.name())), (OutputStream)os, (String)StandardCharsets.UTF_8.name(), (String)StandardCharsets.UTF_8.name(), (boolean)false, inputParams);
            ByteArrayOutputStream os2 = new ByteArrayOutputStream();
            JsonUtils.convertXmlToJson((InputStream)new ByteArrayInputStream(os.toByteArray()), (OutputStream)os2, (String)StandardCharsets.UTF_8.name(), (String)StandardCharsets.UTF_8.name());
            String body = new String(os2.toByteArray());
            HttpClientResponseHandler result = r -> {
                ArrayList<MdNode> nodes = new ArrayList<MdNode>();
                JSONReverser jsonR = new JSONReverser();
                jsonR.setParentNode(currentNode);
                String charsetAsString = StandardCharsets.UTF_8.name();
                try {
                    String contentType = r.getEntity().getContentType();
                    Charset charset = ContentType.parseLenient((CharSequence)contentType).getCharset();
                    if (charset != null) {
                        charsetAsString = charset.name();
                    }
                }
                catch (Exception e) {
                    logger.debug("Cannot parse content type", (Throwable)e);
                }
                try {
                    MdNode aggs;
                    MdNode aggregations;
                    MdNode n = jsonR.reverse(r.getEntity().getContent(), charsetAsString);
                    MdNode hits = n.getNodeByName("com.stambia.json.object", "hits");
                    if (hits != null && (hits = hits.getNodeByName("com.stambia.json.array", "hits")) != null && !hits.getNode().isEmpty()) {
                        for (MdNode _node : hits.getNode()) {
                            _node.setName("hit");
                            for (MdNode __node : _node.getNode()) {
                                if (__node.getName().equals("_source")) {
                                    __node.setName("document");
                                }
                                if (!__node.getName().startsWith("_")) continue;
                                __node.setName(__node.getName().substring(1));
                            }
                        }
                        nodes.add(hits);
                    }
                    if ((aggregations = n.getNodeByName("com.stambia.json.object", "aggregations")) != null) {
                        nodes.add(aggregations);
                    }
                    if ((aggs = n.getNodeByName("com.stambia.json.object", "aggs")) != null) {
                        aggs.setName("aggregations");
                        nodes.add(aggs);
                    }
                    return nodes;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            return (List)client.post(strUrl, body, headers, credentials, credentials != null, result);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
    }

    public static void reverse(MdNode node, int mode, String data) throws ExecuteException {
        try {
            MdNode server = (MdNode)node.eContainer();
            List<MdNode> nodes = ReverseSearchAction.getReversedNodes(node, mode, data, ReverseDocAction.getSslContext(server));
            HashMap<MdNode, MdNode> reverseNodes = new HashMap<MdNode, MdNode>();
            for (MdNode n : new ArrayList<MdNode>(nodes)) {
                reverseNodes.put(n, node.getNodeByName(n.getDefType(), n.getName()));
                n.setSubstituteContainer((EObject)node);
                if (!(n.eContainer() instanceof MdNode)) continue;
                ((MdNode)n.eContainer()).getNode().remove((Object)n);
            }
            IncrementalReverser ir = new IncrementalReverser((EObject)node, reverseNodes, Collections.EMPTY_LIST, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
            ir.reverse();
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
    }
}

