/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.sap;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.addons.sap.Messages;
import com.indy.engine.addons.sap.utils.JCOProvider;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.util.Properties;

public class SapAbstractActionCodeI
extends ActionCodeTypeI {
    private String clientStr;
    private String system;
    private String host;
    private String user;
    private String password;
    private String language;
    private Boolean enableMs;
    private String r3Name;
    private String group;

    public String getClientStr() {
        return this.clientStr;
    }

    public String getSystem() {
        return this.system;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLanguage() {
        return this.language;
    }

    public SapAbstractActionCodeI(String str, boolean b) {
        super(str, b);
    }

    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        String tmp;
        this.clientStr = this.getLocalStringBindedParameter(sourceRSet, "SAP_CLIENT");
        if (this.clientStr == null) {
            throw new EngineExceptionI(Messages.getString("SapAbstractActionCodeI.0"));
        }
        this.system = this.getLocalStringBindedParameter(sourceRSet, "SAP_SYSTEM");
        if (this.system == null) {
            throw new EngineExceptionI(Messages.getString("SapAbstractActionCodeI.1"));
        }
        this.host = this.getLocalStringBindedParameter(sourceRSet, "SAP_HOST");
        if (this.host == null) {
            throw new EngineExceptionI(Messages.getString("SapAbstractActionCodeI.2"));
        }
        this.user = this.getLocalStringBindedParameter(sourceRSet, "SAP_USER");
        if (this.user == null) {
            throw new EngineExceptionI(Messages.getString("SapAbstractActionCodeI.3"));
        }
        this.password = this.getLocalStringBindedParameter(sourceRSet, "SAP_UNCRYPTED_RPASSWORD", null);
        if (this.password == null && (tmp = this.getLocalStringBindedParameter(sourceRSet, "SAP_PASSWORD", null)) != null) {
            this.password = this.decryptString(tmp);
        }
        if (this.password == null) {
            throw new EngineExceptionI(Messages.getString("SapAbstractActionCodeI.4"));
        }
        this.enableMs = this.getLocalBooleanBindedParameter(sourceRSet, "SAP_ENABLE_MS", false);
        this.r3Name = this.getLocalStringBindedParameter(sourceRSet, "SAP_R3_NAME", null);
        this.group = this.getLocalStringBindedParameter(sourceRSet, "SAP_GROUP", null);
        this.language = this.getLocalStringBindedParameter(sourceRSet, "SAP_LANGUAGE", null);
        return 0;
    }

    public Boolean getEnableMs() {
        return this.enableMs;
    }

    public String getR3Name() {
        return this.r3Name;
    }

    public String getGroup() {
        return this.group;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    protected static JCoDestination connect(SapAbstractActionCodeI action, String destinationId) throws Exception {
        Properties properties = new Properties();
        if (action.getEnableMs().booleanValue()) {
            properties.setProperty("jco.client.mshost", action.getHost());
            if (action.getR3Name() != null && !action.getR3Name().isEmpty()) {
                properties.setProperty("jco.client.r3name", action.getR3Name());
            }
            if (action.getGroup() != null && !action.getGroup().isEmpty()) {
                properties.setProperty("jco.client.group", action.getGroup());
            }
        } else {
            properties.setProperty("jco.client.ashost", action.getHost());
        }
        properties.setProperty("jco.client.sysnr", action.getSystem());
        properties.setProperty("jco.client.client", action.getClientStr());
        properties.setProperty("jco.client.user", action.getUser());
        properties.setProperty("jco.client.passwd", action.getPassword());
        properties.setProperty("jco.client.lang", action.getLanguage());
        properties.setProperty("jco.destination.repository_destination", destinationId);
        JCOProvider.getInstance().addDestinationProperties(destinationId, properties);
        JCoDestination destination = JCoDestinationManager.getDestination((String)destinationId);
        destination.getRepository();
        return destination;
    }
}

