/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.sap;

import com.indy.engine.addons.sap.Messages;
import com.indy.engine.addons.sap.XmlReaderWriter;
import com.indy.engine.core.actionCodes.convert.AbstractDataTypeConverter;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class SapRfcWithXml {
    private XmlReaderWriter readWrite;
    static final String mdNameSpaceUri = "http://www.stambia.com/md";
    static final QName abapName = new QName("http://www.stambia.com/md", "abapName");
    JCoFunction function;
    JCoTable currentTable = null;
    JCoStructure currentStructure;
    Map<String, MyTable> tables = new HashMap<String, MyTable>();
    private List<MyStruc> structs = new ArrayList<MyStruc>();
    private List<MyField> fields = new ArrayList<MyField>();
    String rootName;
    String encoding;
    String xmlOutPutFactoryClassName;
    String xmlInPutFactoryClassName;
    int rfcInvocation = 0;
    int importFieldNumber = 0;
    int exportFieldNumber = 0;
    boolean executed = false;
    boolean extractAll = false;
    boolean emptyValueAsNull = true;
    private JCoDestination destination;
    AbstractDataTypeConverter dataTypeConverter;
    Map<String, JCoFunctionTemplate> functionsTemplate = new HashMap<String, JCoFunctionTemplate>();

    public void readAndWriteFile(InputStream inputStream, OutputStream outputStream) throws FactoryConfigurationError, Exception {
        this.readWrite = new XmlReaderWriter();
        this.readWrite.addReadWrite("/" + this.rootName + "/com.stambia.appl.sap.bapi", new XmlReaderWriter(){

            @Override
            public void handleStart(XMLEvent event) throws Exception {
                super.handleStart(event);
                StartElement elt = event.asStartElement();
                Attribute attr = elt.getAttributeByName(abapName);
                if (attr == null || attr.getValue() == null) {
                    throw new Exception(Messages.getString("SapRfcWithXml.0"));
                }
                SapRfcWithXml.this.function = SapRfcWithXml.this.createFunction(attr.getValue());
            }

            @Override
            public void handleStop(XMLEvent event) throws Exception {
                SapRfcWithXml.this.executeAndWriteTable(false);
                SapRfcWithXml.this.writeExport();
                SapRfcWithXml.this.handleEndInvocation();
                SapRfcWithXml.this.function = null;
                SapRfcWithXml.this.executed = false;
            }

            @Override
            public void init() {
                this.addReadWrite("/com.stambia.appl.sap.bapi.importParameterContainer", new XmlReaderWriter(){

                    @Override
                    public void handleStart(XMLEvent event) throws Exception {
                        super.handleStart(event);
                        JCoParameterList importParams = (this).SapRfcWithXml.this.function.getImportParameterList();
                        JCoParameterList changingParams = (this).SapRfcWithXml.this.function.getChangingParameterList();
                        Iterator<Attribute> it = event.asStartElement().getAttributes();
                        while (it.hasNext()) {
                            Attribute attr = it.next();
                            if (attr.getName().getNamespaceURI() != null && attr.getName().getNamespaceURI().equals(SapRfcWithXml.mdNameSpaceUri)) continue;
                            String name = attr.getName().getLocalPart();
                            if (importParams.getMetaData().hasField(name)) {
                                importParams.setValue(name, SapRfcWithXml.this.xmlStringToSapJco(attr.getValue(), importParams.getMetaData().getType(name)));
                            } else {
                                changingParams.setValue(name, SapRfcWithXml.this.xmlStringToSapJco(attr.getValue(), changingParams.getMetaData().getType(name)));
                            }
                            SapRfcWithXml.this.handleRfcEvent(EVENT.IMPORT_PARAMAMETER);
                        }
                    }
                });
                this.addReadWrite("/com.stambia.appl.sap.bapi.importStructureContainer/com.stambia.appl.sap.bapi.structure", new XmlReaderWriter(){

                    @Override
                    public void handleStart(XMLEvent event) throws Exception {
                        super.handleStart(event);
                        JCoParameterList importParams = (this).SapRfcWithXml.this.function.getImportParameterList();
                        JCoParameterList changingParams = (this).SapRfcWithXml.this.function.getChangingParameterList();
                        if ((this).SapRfcWithXml.this.currentStructure == null) {
                            String name = event.asStartElement().getName().getLocalPart();
                            if (importParams != null && importParams.getMetaData().hasField(name)) {
                                (this).SapRfcWithXml.this.currentStructure = importParams.getStructure(name);
                            } else if (changingParams != null) {
                                (this).SapRfcWithXml.this.currentStructure = changingParams.getStructure(name);
                            }
                        }
                        SapRfcWithXml.this.handleRfcEvent(EVENT.IMPORT_STRUCTURE);
                        Iterator<Attribute> it = event.asStartElement().getAttributes();
                        while (it.hasNext()) {
                            Attribute attr = it.next();
                            if (attr.getName().getNamespaceURI() != null && attr.getName().getNamespaceURI().equals(SapRfcWithXml.mdNameSpaceUri)) continue;
                            String name = attr.getName().getLocalPart();
                            (this).SapRfcWithXml.this.currentStructure.setValue(name, SapRfcWithXml.this.xmlStringToSapJco(attr.getValue(), (this).SapRfcWithXml.this.currentStructure.getMetaData().getType(name)));
                            SapRfcWithXml.this.handleRfcEvent(EVENT.IMPORT_STRUCTURE_FIELD);
                        }
                    }

                    @Override
                    public void handleStop(XMLEvent event) {
                        (this).SapRfcWithXml.this.currentStructure = null;
                    }
                });
                this.addReadWrite("/com.stambia.appl.sap.bapi.tableContainer", new XmlReaderWriter(){

                    @Override
                    public void init() {
                        this.addReadWrite("/com.stambia.appl.sap.bapi.table", new XmlReaderWriter(){

                            @Override
                            public void handleWrite(XMLEvent event) throws XMLStreamException {
                            }

                            @Override
                            public void handleStart(XMLEvent event) throws Exception {
                                super.handleStart(event);
                                if (((this).this).SapRfcWithXml.this.currentTable == null) {
                                    ((this).this).SapRfcWithXml.this.currentTable = ((this).this).SapRfcWithXml.this.function.getTableParameterList().getTable(event.asStartElement().getName().getLocalPart());
                                    SapRfcWithXml.this.handleRfcEvent(EVENT.OUT_TABLE);
                                }
                                ((this).this).SapRfcWithXml.this.currentTable.appendRow();
                                SapRfcWithXml.this.handleRfcEvent(EVENT.OUT_TABLE_ROW);
                                Iterator<Attribute> it = event.asStartElement().getAttributes();
                                while (it.hasNext()) {
                                    Attribute attr = it.next();
                                    if (attr.getName().getNamespaceURI() != null && attr.getName().getNamespaceURI().equals(SapRfcWithXml.mdNameSpaceUri)) continue;
                                    String name = attr.getName().getLocalPart();
                                    ((this).this).SapRfcWithXml.this.currentTable.setValue(name, SapRfcWithXml.this.xmlStringToSapJco(attr.getValue(), ((this).this).SapRfcWithXml.this.currentTable.getMetaData().getType(name)));
                                    SapRfcWithXml.this.handleRfcEvent(EVENT.OUT_TABLE_COLUMN);
                                }
                            }

                            @Override
                            public void handleStop(XMLEvent event) {
                                ((this).this).SapRfcWithXml.this.currentTable = null;
                            }
                        });
                    }

                    @Override
                    public void handleStop(XMLEvent event) throws Exception {
                        SapRfcWithXml.this.executeAndWriteTable(true);
                    }
                });
            }
        });
        XmlReaderWriter.readWrite(inputStream, outputStream, this.readWrite, null, this.encoding, this.xmlInPutFactoryClassName, this.xmlOutPutFactoryClassName);
    }

    public void setXmlOutPutFactoryClassName(String xmlOutPutFactoryClassName) {
        this.xmlOutPutFactoryClassName = xmlOutPutFactoryClassName;
    }

    public void setXmlInPutFactoryClassName(String xmlInPutFactoryClassName) {
        this.xmlInPutFactoryClassName = xmlInPutFactoryClassName;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getRfcInvocation() {
        return this.rfcInvocation;
    }

    public int getImportFieldNumber() {
        return this.importFieldNumber;
    }

    public int getExportFieldNumber() {
        return this.exportFieldNumber;
    }

    private void handleRfcEvent(EVENT stat) {
        switch (stat) {
            case EXPORT_PARAMETER: 
            case OUT_TABLE_COLUMN: 
            case EXPORT_STRUCTURE_FIELD: {
                ++this.exportFieldNumber;
                this.handleStatistics(this.rfcInvocation, this.importFieldNumber, this.exportFieldNumber);
                break;
            }
            case IMPORT_PARAMAMETER: 
            case IN_TABLE_COLUMN: 
            case IMPORT_STRUCTURE_FIELD: {
                ++this.importFieldNumber;
                this.handleStatistics(this.rfcInvocation, this.importFieldNumber, this.exportFieldNumber);
                break;
            }
            case INVOCATION: {
                ++this.rfcInvocation;
                this.handleStatistics(this.rfcInvocation, this.importFieldNumber, this.exportFieldNumber);
            }
        }
    }

    protected abstract void handleEndInvocation();

    protected abstract void handleStatistics(int var1, int var2, int var3);

    public void initMetaData(InputStream is) throws FactoryConfigurationError, Exception {
        XmlReaderWriter md = new XmlReaderWriter();
        md.addReadWrite("/com.stambia.appl.sap.bapi", new XmlReaderWriter(){

            @Override
            public void handleStart(XMLEvent event) throws Exception {
                super.handleStart(event);
            }

            @Override
            public void init() {
                super.addReadWrite("/com.stambia.appl.sap.bapi.importParameterContainer/com.stambia.appl.sap.bapi.field", new XmlReaderWriter(){
                    MyField _field;

                    @Override
                    public void handleStart(XMLEvent event) throws Exception {
                        super.handleStart(event);
                        this._field = new MyField();
                        this._field.name = event.asStartElement().getAttributeByName(new QName("name")).getValue();
                        this._field.typeName = event.asStartElement().getAttributeByName(new QName("type")).getValue();
                        (this).SapRfcWithXml.this.fields.add(this._field);
                    }

                    @Override
                    public void init() {
                    }
                });
                super.addReadWrite("/com.stambia.appl.sap.bapi.importStructureContainer/com.stambia.appl.sap.bapi.structure", new XmlReaderWriter(){
                    MyStruc _struct;

                    @Override
                    public void handleStart(XMLEvent event) throws Exception {
                        super.handleStart(event);
                        this._struct = new MyStruc();
                        this._struct.name = event.asStartElement().getAttributeByName(new QName("name")).getValue();
                        (this).SapRfcWithXml.this.structs.add(this._struct);
                    }

                    @Override
                    public void init() {
                        super.addReadWrite("/com.stambia.appl.sap.bapi.field", new XmlReaderWriter(){
                            MyField _field;

                            @Override
                            public void handleStart(XMLEvent event) throws Exception {
                                super.handleStart(event);
                                this._field = new MyField();
                                this._field.name = event.asStartElement().getAttributeByName(new QName("name")).getValue();
                                this._field.typeName = event.asStartElement().getAttributeByName(new QName("type")).getValue();
                                _struct.fields.add(this._field);
                            }

                            @Override
                            public void init() {
                            }
                        });
                    }
                });
                super.addReadWrite("/com.stambia.appl.sap.bapi.tableContainer/com.stambia.appl.sap.bapi.table", new XmlReaderWriter(){
                    MyTable _table;

                    @Override
                    public void handleStart(XMLEvent event) throws Exception {
                        super.handleStart(event);
                        this._table = new MyTable();
                        this._table.name = event.asStartElement().getAttributeByName(new QName("name")).getValue();
                        (this).SapRfcWithXml.this.tables.put(this._table.name, this._table);
                    }

                    @Override
                    public void init() {
                        super.addReadWrite("/com.stambia.appl.sap.bapi.field", new XmlReaderWriter(){
                            MyField _field;

                            @Override
                            public void handleStart(XMLEvent event) throws Exception {
                                super.handleStart(event);
                                this._field = new MyField();
                                this._field.name = event.asStartElement().getAttributeByName(new QName("name")).getValue();
                                this._field.typeName = event.asStartElement().getAttributeByName(new QName("type")).getValue();
                                _table.fields.add(this._field);
                            }

                            @Override
                            public void init() {
                            }
                        });
                    }
                });
            }
        });
        try {
            XmlReaderWriter.readWrite(is, null, md, "UTF-8", "UTF-8", this.xmlInPutFactoryClassName, this.xmlOutPutFactoryClassName);
        }
        finally {
            is.close();
        }
    }

    public SapRfcWithXml(String rootName, AbstractDataTypeConverter dataTypeProvider) {
        this.rootName = rootName;
        this.dataTypeConverter = dataTypeProvider;
    }

    public void clear() {
        this.functionsTemplate.clear();
    }

    public void addStartElement(StartElement start) throws XMLStreamException {
        this.readWrite.writer.add(start);
    }

    public void addEndElement(EndElement end) throws XMLStreamException {
        this.readWrite.writer.add(end);
        this.handleRfcEvent(EVENT.WRITE_XML_ELEMENT);
    }

    public void addAttribute(Attribute attr) throws XMLStreamException {
        this.readWrite.writer.add(attr);
        this.handleRfcEvent(EVENT.WRITE_XML_ATTRIBUTE);
    }

    private void executeAndWriteTable(boolean inTables) throws Exception {
        if (!this.executed) {
            this.executed = true;
            JCoContext.begin((JCoDestination)this.destination);
            this.function.execute(this.destination);
            JCoFunction _function = this.createFunction("BAPI_TRANSACTION_COMMIT");
            _function.execute(this.destination);
            JCoContext.end((JCoDestination)this.destination);
            this.handleStartInvocation();
            this.handleRfcEvent(EVENT.INVOCATION);
            JCoParameterList _list = this.function.getTableParameterList();
            if (_list != null) {
                JCoMetaData md = _list.getMetaData();
                if (!inTables) {
                    this.addStartElement(this.readWrite.m_eventFactory.createStartElement("", null, "Tables"));
                }
                int i = 0;
                while (i < md.getFieldCount()) {
                    MyTable __tab;
                    String tabName = md.getName(i);
                    JCoTable _table = _list.getTable(i);
                    if (_table.getNumRows() > 0 && ((__tab = this.tables.get(tabName)) != null || this.extractAll)) {
                        this.handleRfcEvent(EVENT.IN_TABLE);
                        JCoMetaData _mdTable = _table.getMetaData();
                        ArrayList<Integer> fieldList = new ArrayList<Integer>();
                        ArrayList<Integer> fieldType = new ArrayList<Integer>();
                        int k = 0;
                        while (k < _mdTable.getFieldCount()) {
                            fieldList.add(k);
                            fieldType.add(_mdTable.getType(k));
                            ++k;
                        }
                        int j = 0;
                        while (j < _table.getNumRows()) {
                            this.handleRfcEvent(EVENT.IN_TABLE_ROW);
                            this.addStartElement(this.readWrite.m_eventFactory.createStartElement("", null, tabName));
                            _table.setRow(j);
                            Iterator iterator = fieldList.iterator();
                            while (iterator.hasNext()) {
                                int k2 = (Integer)iterator.next();
                                this.handleRfcEvent(EVENT.IN_TABLE_COLUMN);
                                this.writeField((JCoRecord)_table, k2, (Integer)fieldType.get(k2));
                            }
                            this.addEndElement(this.readWrite.m_eventFactory.createEndElement("", null, tabName));
                            ++j;
                        }
                    }
                    ++i;
                }
                if (!inTables) {
                    this.addEndElement(this.readWrite.m_eventFactory.createEndElement("", null, "Tables"));
                }
            }
        }
    }

    public Object xmlStringToSapJco(String value, int jcoType) {
        switch (jcoType) {
            case 0: 
            case 6: 
            case 29: {
                return value;
            }
            case 1: {
                Calendar d = DatatypeConverter.parseDate((String)value);
                return d.getTime();
            }
            case 7: {
                return Float.valueOf(DatatypeConverter.parseFloat((String)value));
            }
            case 2: {
                return DatatypeConverter.parseDecimal((String)value);
            }
            case 8: 
            case 9: 
            case 10: {
                return DatatypeConverter.parseInt((String)value);
            }
            case 3: {
                Calendar t = DatatypeConverter.parseTime((String)value);
                return t.getTime();
            }
            case 4: {
                return DatatypeConverter.parseBase64Binary((String)value);
            }
        }
        return value;
    }

    public String sapJcoObjectToXmlString(JCoRecord r, int index, int jcoType) throws EngineExceptionI {
        switch (jcoType) {
            case 0: 
            case 6: 
            case 29: {
                return r.getString(index);
            }
            case 1: {
                Date d = r.getDate(index);
                if (d != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(d);
                    return this.dataTypeConverter.getUnparser().printDateTime(cal, jcoType);
                }
                return null;
            }
            case 7: {
                float f = r.getFloat(index);
                return this.dataTypeConverter.getUnparser().printFloat(Float.valueOf(f), jcoType);
            }
            case 2: {
                BigDecimal bd = r.getBigDecimal(index);
                if (bd != null) {
                    return this.dataTypeConverter.getUnparser().printDecimal(bd, jcoType);
                }
                return null;
            }
            case 8: 
            case 9: 
            case 10: {
                int i = r.getInt(index);
                return String.valueOf(i);
            }
            case 3: {
                Date t = r.getTime(index);
                if (t != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(t);
                    return this.dataTypeConverter.getUnparser().printDateTime(cal, jcoType);
                }
                return null;
            }
            case 4: {
                byte[] b = r.getByteArray(index);
                return DatatypeConverter.printBase64Binary((byte[])b);
            }
        }
        return r.getString(index);
    }

    private void writeField(JCoRecord r, int index, int type) throws XMLStreamException, EngineExceptionI {
        String value = this.sapJcoObjectToXmlString(r, index, type);
        if (!(value == null || this.emptyValueAsNull && value.isEmpty())) {
            this.addAttribute(this.readWrite.m_eventFactory.createAttribute(r.getMetaData().getName(index), value));
        }
    }

    private void writeExportParameters(JCoParameterList _list) throws XMLStreamException, EngineExceptionI {
        if (_list != null) {
            JCoListMetaData md = _list.getListMetaData();
            int j = 0;
            while (j < md.getFieldCount()) {
                if (md.isExport(j) || md.isChanging(j)) {
                    this.writeField((JCoRecord)_list, j, md.getType(j));
                    this.handleRfcEvent(EVENT.EXPORT_PARAMETER);
                }
                ++j;
            }
        }
    }

    private void writeExportStructures(JCoParameterList _list) throws XMLStreamException, EngineExceptionI {
        if (_list != null) {
            JCoListMetaData md = _list.getListMetaData();
            int j = 0;
            while (j < md.getFieldCount()) {
                if (md.isStructure(j)) {
                    this.handleRfcEvent(EVENT.EXPORT_STRUCTURE);
                    JCoStructure struc = _list.getStructure(j);
                    JCoRecordMetaData md2 = struc.getRecordMetaData();
                    this.addStartElement(this.readWrite.m_eventFactory.createStartElement("", null, md.getName(j)));
                    int k = 0;
                    while (k < md2.getFieldCount()) {
                        this.handleRfcEvent(EVENT.EXPORT_STRUCTURE_FIELD);
                        this.writeField((JCoRecord)struc, k, md2.getType(k));
                        ++k;
                    }
                    this.addEndElement(this.readWrite.m_eventFactory.createEndElement("", null, md.getName(j)));
                }
                ++j;
            }
        }
    }

    public void writeExport() throws XMLStreamException, EngineExceptionI {
        if (this.executed) {
            JCoListMetaData md;
            JCoParameterList exportParamList = this.function.getExportParameterList();
            JCoParameterList changingParamList = this.function.getChangingParameterList();
            boolean hasFields = false;
            if (exportParamList != null && (md = exportParamList.getListMetaData()).getFieldCount() > 0) {
                hasFields = true;
            }
            if (changingParamList != null && (md = changingParamList.getListMetaData()).getFieldCount() > 0) {
                hasFields = true;
            }
            if (hasFields) {
                this.addStartElement(this.readWrite.m_eventFactory.createStartElement("", null, "ExportStructures"));
                this.writeExportStructures(exportParamList);
                this.writeExportStructures(changingParamList);
                this.addEndElement(this.readWrite.m_eventFactory.createEndElement("", null, "ExportStructures"));
                this.addStartElement(this.readWrite.m_eventFactory.createStartElement("", null, "ExportParameters"));
                this.writeExportParameters(exportParamList);
                this.writeExportParameters(changingParamList);
                this.addEndElement(this.readWrite.m_eventFactory.createEndElement("", null, "ExportParameters"));
            }
        }
    }

    public JCoFunction createFunction(String name) throws Exception {
        JCoFunctionTemplate ft;
        block4: {
            try {
                ft = this.functionsTemplate.get(name.toUpperCase());
                if (ft == null && (ft = this.destination.getRepository().getFunctionTemplate(name.toUpperCase())) != null) {
                    this.functionsTemplate.put(name.toUpperCase(), ft);
                }
                if (ft != null) break block4;
                return null;
            }
            catch (Exception ex) {
                throw new Exception(Messages.getString("SapRfcWithXml.1"));
            }
        }
        return ft.getFunction();
    }

    public void setDestination(JCoDestination destination) {
        this.destination = destination;
    }

    protected abstract void handleStartInvocation();

    static enum EVENT {
        INVOCATION,
        IMPORT_PARAMAMETER,
        EXPORT_PARAMETER,
        IN_TABLE,
        IN_TABLE_ROW,
        IN_TABLE_COLUMN,
        OUT_TABLE,
        OUT_TABLE_ROW,
        OUT_TABLE_COLUMN,
        EXPORT_STRUCTURE,
        EXPORT_STRUCTURE_FIELD,
        IMPORT_STRUCTURE,
        IMPORT_STRUCTURE_FIELD,
        WRITE_XML_ELEMENT,
        WRITE_XML_ATTRIBUTE;

    }

    class MyField {
        String name;
        String typeName;

        MyField() {
        }
    }

    class MyStruc {
        String name;
        List<MyField> fields = new ArrayList<MyField>();

        MyStruc() {
        }
    }

    class MyTable {
        String name;
        List<MyField> fields = new ArrayList<MyField>();

        MyTable() {
        }
    }
}

