/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.mongodb.action;

import com.indy.addons.mongodb.action.ExternalValueResolverMongoDBHelper;
import com.indy.addons.mongodb.action.Messages;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.ui.custom.out.services.IExternalValueResolver;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoQueryException;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterConnectionMode;
import com.semarchy.xdi.designer.core.utils.StringUtils;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ReverseException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;

public class MongoClientUtil {
    private static final Logger LOGGER = Logger.getLogger(MongoClientUtil.class.getName());
    static final String ANCESTOR_OR_SELF = "ancestor-or-self::*/@";
    static final String MONGO_PASSWORD = "mongoPassword";
    static final String MONGO_CONNECTION_METHOD = "mongoConnectionMethod";
    static final String MONGO_AUTH_DATABASE = "mongoAuthDatabase";
    static final String MONGO_USER = "mongoUser";
    static final String MONGO_PORT = "mongoPort";
    static final String MONGO_HOST = "mongoHost";
    static final String MONGO_URL = "mongoUrl";
    static final String MONGO_SSL = "mongoSsl";
    static final String MONGO_SRV = "mongoSrv";
    static final String MONGO_AUTH_TYPE = "mongoAuthType";
    static final String DEFAULT_PORT = "27017";
    private static final int UNAUTHORIZED_ERROR_CODE = 13;
    private static final String UNAUTHORIZED_ERROR_CODE_NAME = "Unauthorized";

    private MongoClientUtil() {
    }

    static MongoClient createMongoClient(MdNode currentNode, IExternalValueResolver resolver, Function<String, ? extends Exception> exceptionFactory) throws Exception {
        return MongoClientUtil.createMongoClient(new MongoConnection(new MdNodeWrapper(currentNode), exceptionFactory), resolver, exceptionFactory);
    }

    private static MongoClient createMongoClient(MongoConnection connection, IExternalValueResolver resolver, Function<String, ? extends Exception> exceptionFactory) throws Exception {
        switch (connection.connectionMethod) {
            case URL: {
                MongoClientURI uri = new MongoClientURI(ExternalValueResolverMongoDBHelper.resolve(connection.url, resolver));
                return new MongoClient(uri);
            }
            case USER_PASSWORD: {
                String database = "admin";
                if (connection.authDatabase != null && !connection.authDatabase.isEmpty()) {
                    database = ExternalValueResolverMongoDBHelper.resolve(connection.authDatabase, resolver);
                }
                String user = ExternalValueResolverMongoDBHelper.resolve(connection.user, resolver);
                char[] password = ExternalValueResolverMongoDBHelper.resolve(connection.password, resolver).toCharArray();
                MongoCredential credential = MongoClientUtil.createCredentials(connection.authType, user, database, password);
                List<ServerAddress> hosts = connection.srv ? null : Collections.singletonList(new ServerAddress(ExternalValueResolverMongoDBHelper.resolve(connection.host, resolver), Integer.parseInt(ExternalValueResolverMongoDBHelper.resolve(connection.port, resolver))));
                String srvHost = connection.srv ? ExternalValueResolverMongoDBHelper.resolve(connection.host, resolver) : null;
                ClusterConnectionMode connectionMode = connection.srv ? ClusterConnectionMode.MULTIPLE : ClusterConnectionMode.SINGLE;
                MongoClientSettings settings = MongoClientOptions.builder().sslEnabled(connection.ssl).build().asMongoClientSettings(hosts, srvHost, connectionMode, credential);
                return new MongoClient(settings);
            }
        }
        throw exceptionFactory.apply(Messages.MongoClientUtil_0);
    }

    private static MongoCredential createCredentials(MongoAuthType authType, String user, String database, char[] password) {
        return switch (authType) {
            case MongoAuthType.AUTO -> MongoCredential.createCredential((String)user, (String)database, (char[])password);
            case MongoAuthType.AWS -> MongoCredential.createAwsCredential((String)user, (char[])password);
            case MongoAuthType.PLAIN -> MongoCredential.createPlainCredential((String)user, (String)database, (char[])password);
            case MongoAuthType.SCRAM_SHA_1 -> MongoCredential.createScramSha1Credential((String)user, (String)database, (char[])password);
            case MongoAuthType.SCRAM_SHA_256 -> MongoCredential.createScramSha256Credential((String)user, (String)database, (char[])password);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    protected static void manageAuthorizationErrorOnReverse(Exception e) throws ReverseException {
        String errorMessage = e.getMessage();
        if (e instanceof MongoQueryException) {
            MongoQueryException mongoQueryException = (MongoQueryException)e;
            int errorCode = mongoQueryException.getCode();
            String errorCodeName = mongoQueryException.getErrorCodeName();
            if (13 != errorCode || !UNAUTHORIZED_ERROR_CODE_NAME.equalsIgnoreCase(errorCodeName)) {
                LOGGER.severe(errorMessage);
                throw new ReverseException((Throwable)e);
            }
        } else {
            LOGGER.severe(errorMessage);
            throw new ReverseException((Throwable)e);
        }
        LOGGER.warning(errorMessage);
    }

    private static class MdNodeWrapper {
        private MdNode currentNode;

        public MdNodeWrapper(MdNode currentNode) {
            this.currentNode = currentNode;
        }

        public String evaluate(String value) throws XPathExpressionException {
            return this.currentNode.evaluate(MongoClientUtil.ANCESTOR_OR_SELF + value);
        }
    }

    private static enum MongoAuthType {
        SCRAM_SHA_1("SCRAM-SHA-1"),
        SCRAM_SHA_256("SCRAM-SHA-256"),
        PLAIN("PLAIN"),
        AWS("AWS"),
        AUTO("AUTO");

        private String value;

        private MongoAuthType(String value) {
            this.value = value;
        }

        private static MongoAuthType parse(String value) {
            MongoAuthType[] mongoAuthTypeArray = MongoAuthType.values();
            int n = mongoAuthTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MongoAuthType authType = mongoAuthTypeArray[n2];
                if (Objects.equals(value, authType.value)) {
                    return authType;
                }
                ++n2;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class MongoConnection {
        final MongoConnectionMethod connectionMethod;
        final String url;
        final String user;
        final String password;
        final String authDatabase;
        final String host;
        final String port;
        final boolean ssl;
        final boolean srv;
        final MongoAuthType authType;

        private MongoConnection(MdNodeWrapper node, Function<String, ? extends Exception> exceptionFactory) throws Exception {
            this.url = node.evaluate(MongoClientUtil.MONGO_URL);
            this.host = node.evaluate(MongoClientUtil.MONGO_HOST);
            this.port = StringUtils.defaultIfBlank((String)node.evaluate(MongoClientUtil.MONGO_PORT), (String)MongoClientUtil.DEFAULT_PORT);
            this.user = node.evaluate(MongoClientUtil.MONGO_USER);
            this.authDatabase = node.evaluate(MongoClientUtil.MONGO_AUTH_DATABASE);
            try {
                String connectionMethodAsString = StringUtils.defaultIfBlank((String)node.evaluate(MongoClientUtil.MONGO_CONNECTION_METHOD), (String)MongoConnectionMethod.URL.value);
                this.connectionMethod = MongoConnectionMethod.parse(connectionMethodAsString);
            }
            catch (IllegalArgumentException e) {
                throw exceptionFactory.apply(Messages.MongoClientUtil_0);
            }
            String nullablePassword = node.evaluate(MongoClientUtil.MONGO_PASSWORD);
            this.password = this.connectionMethod == MongoConnectionMethod.USER_PASSWORD && nullablePassword != null && !nullablePassword.isEmpty() ? this.decryptPassword(nullablePassword) : nullablePassword;
            this.ssl = Boolean.parseBoolean(node.evaluate(MongoClientUtil.MONGO_SSL));
            this.srv = Boolean.parseBoolean(node.evaluate(MongoClientUtil.MONGO_SRV));
            try {
                String authTypeAsString = StringUtils.defaultIfBlank((String)node.evaluate(MongoClientUtil.MONGO_AUTH_TYPE), (String)MongoAuthType.AUTO.value);
                this.authType = MongoAuthType.parse(authTypeAsString);
            }
            catch (IllegalArgumentException e) {
                throw exceptionFactory.apply(Messages.MongoClientUtil_1);
            }
            this.validate(exceptionFactory);
        }

        private void validate(Function<String, ? extends Exception> exceptionFactory) throws Exception {
            if (this.connectionMethod == MongoConnectionMethod.URL && (this.url == null || this.url.isEmpty())) {
                throw exceptionFactory.apply(Messages.ReverseDocAction_0);
            }
            if (this.connectionMethod == MongoConnectionMethod.USER_PASSWORD) {
                if (this.host == null || this.host.isEmpty()) {
                    throw exceptionFactory.apply(Messages.ReverseDocAction_33);
                }
                if (this.user == null || this.user.isEmpty()) {
                    throw exceptionFactory.apply(Messages.ReverseDocAction_35);
                }
            }
        }

        private String decryptPassword(String mongoPassword) {
            try {
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                return semaphoreManager.getStringAsciiInfo(mongoPassword);
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
                return mongoPassword;
            }
        }
    }

    private static enum MongoConnectionMethod {
        URL("URL"),
        USER_PASSWORD("UserPassword");

        private String value;

        private MongoConnectionMethod(String value) {
            this.value = value;
        }

        private static MongoConnectionMethod parse(String value) {
            MongoConnectionMethod[] mongoConnectionMethodArray = MongoConnectionMethod.values();
            int n = mongoConnectionMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                MongoConnectionMethod method = mongoConnectionMethodArray[n2];
                if (Objects.equals(value, method.value)) {
                    return method;
                }
                ++n2;
            }
            throw new IllegalArgumentException();
        }
    }
}

