/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.mongodb.action;

import com.indy.addons.json.JSONReverser;
import com.indy.addons.mongodb.action.MongoClientUtil;
import com.indy.ui.custom.out.services.IExternalValueResolver;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class ReverseDocAction
implements IExecute {
    private static final Logger LOGGER = Logger.getLogger(ReverseDocAction.class.getName());
    private IExternalValueResolver resolver;

    public ReverseDocAction() {
        this((IExternalValueResolver)E4InjectorHelper.getService(IExternalValueResolver.class));
    }

    public ReverseDocAction(IExternalValueResolver resolver) {
        this.resolver = resolver;
    }

    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode node = (MdNode)object;
        try {
            this.reverse(node);
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
        return null;
    }

    private void getFieldNameAndType(Document document, MdNode resultingDoc) {
        for (Map.Entry pair : document.entrySet()) {
            this.getDatatype((String)pair.getKey(), pair.getValue(), resultingDoc);
        }
    }

    private void getDatatype(String key, Object val, MdNode resultingJson) {
        if (val instanceof Document) {
            MdNode subObject = this.createNodeObject(resultingJson, key);
            resultingJson.getNode().add((Object)subObject);
            this.getFieldNameAndType((Document)val, subObject);
        } else {
            this.addDataTypeToJson(key, val, resultingJson);
        }
    }

    private void addDataTypeToJson(String key, Object val, MdNode resultingJson) {
        if (val instanceof ObjectId) {
            MdNode subObject = this.createNode(resultingJson, "objectId", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Boolean) {
            MdNode subObject = this.createNode(resultingJson, "boolean", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Integer) {
            MdNode subObject = this.createNode(resultingJson, "int", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Long) {
            MdNode subObject = this.createNode(resultingJson, "long", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Double) {
            MdNode subObject = this.createNode(resultingJson, "double", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Date) {
            MdNode subObject = this.createNode(resultingJson, "date", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof ArrayList) {
            MdNode subObject = this.createNodeArray(resultingJson, key);
            ((ArrayList)val).stream().findFirst().ifPresent(el -> this.getDatatype("item", el, subObject));
            resultingJson.getNode().add((Object)subObject);
        } else {
            MdNode subObject = this.createNode(resultingJson, "string", key);
            resultingJson.getNode().add((Object)subObject);
        }
    }

    protected void reverseType(MdNode collection, MongoCollection<Document> documents) throws ReverseException {
        this.reverseType(collection, (FindIterable<Document>)documents.find());
    }

    protected void reverseType(MdNode collection, FindIterable<Document> documents) throws ReverseException {
        JSONReverser jr = new JSONReverser();
        jr.setParentNode(collection);
        try {
            MongoCursor iterator = documents.iterator();
            if (iterator.hasNext()) {
                this.getFieldNameAndType((Document)iterator.next(), collection);
            }
        }
        catch (Exception e) {
            MongoClientUtil.manageAuthorizationErrorOnReverse(e);
        }
    }

    protected MdNode createNode(MdNode collection, String typeVal, String name) {
        MdNode exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
        exchattr.setName(name);
        collection.getNode().add((Object)exchattr);
        exchattr.setAttribute("type", typeVal, false);
        exchattr.setPosition(BigInteger.valueOf(1L));
        return exchattr;
    }

    protected MdNode createNodeObject(MdNode collection, String name) {
        MdNode exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.object");
        exchattr.setName(name);
        collection.getNode().add((Object)exchattr);
        exchattr.setPosition(BigInteger.valueOf(1L));
        return exchattr;
    }

    protected MdNode createNodeArray(MdNode collection, String name) {
        MdNode exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.array");
        exchattr.setName(name);
        collection.getNode().add((Object)exchattr);
        exchattr.setPosition(BigInteger.valueOf(1L));
        return exchattr;
    }

    protected List<MdNode> getNodes(MongoClient mongoClient, MdNode node) throws XPathExpressionException, ReverseException {
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        try {
            MongoIterable databases = mongoClient.listDatabaseNames();
            for (String databaseNameInsideMongodb : databases) {
                MdNode databaseElement = MdFactoryHelper.createMdNode((String)"com.stambia.mongodb.database");
                databaseElement.setSubstituteContainer((EObject)node);
                databaseElement.setName(databaseNameInsideMongodb);
                databaseElement.setAttribute("physicalName", databaseNameInsideMongodb, false);
                MongoDatabase mongoDatabase = mongoClient.getDatabase(databaseNameInsideMongodb);
                for (String collectionNameInsideMongodb : mongoDatabase.listCollectionNames()) {
                    MdNode collection = MdFactoryHelper.createMdNode((String)"com.stambia.mongodb.collection");
                    collection.setSubstituteContainer((EObject)databaseElement);
                    collection.setName(collectionNameInsideMongodb);
                    collection.setAttribute("physicalName", collectionNameInsideMongodb, false);
                    databaseElement.getNode().add((Object)collection);
                    this.reverseType(collection, (MongoCollection<Document>)mongoDatabase.getCollection(collectionNameInsideMongodb));
                }
                nodes.add(databaseElement);
            }
        }
        catch (Exception e) {
            MongoClientUtil.manageAuthorizationErrorOnReverse(e);
        }
        return nodes;
    }

    protected void reverse(MdNode currentNode) throws ReverseException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (MongoClient mongoClient = MongoClientUtil.createMongoClient(currentNode, this.resolver, ReverseException::new);){
                MdNode server = currentNode;
                if (currentNode.getDefType().contains("com.stambia.mongodb.collection")) {
                    server = (MdNode)currentNode.eContainer().eContainer();
                }
                if (currentNode.getDefType().contains("com.stambia.mongodb.database")) {
                    server = (MdNode)currentNode.eContainer();
                }
                List<MdNode> nodeToReverse = this.getNodes(mongoClient, currentNode);
                HashMap<MdNode, MdNode> reverseNodes = new HashMap<MdNode, MdNode>();
                for (MdNode n : nodeToReverse) {
                    TreeIterator it = n.eAllContents();
                    while (it.hasNext()) {
                        EObject o = (EObject)it.next();
                        if (!(o instanceof MdNode)) continue;
                        ((MdNode)o).setSubstituteContainer(null);
                    }
                    reverseNodes.put(n, server.getNodeByName(n.getDefType(), n.getName()));
                }
                IncrementalReverser ir = new IncrementalReverser((EObject)server, reverseNodes, Collections.emptyList(), false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
                ir.reverse();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ReverseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReverseException((Throwable)e);
        }
    }

    private void getIndexKeys(Document doc, MdNode resultingJson) {
        doc.forEach((key, val) -> {
            if (key.equals("key")) {
                this.getKeysElements((Document)val, resultingJson);
            }
        });
    }

    private void getKeysElements(Document doc, MdNode resultingJson) {
        doc.forEach((key, val) -> {
            if (val instanceof Document) {
                Document document = (Document)val;
                MdNode subObject = this.createNodeObject(resultingJson, (String)key);
                resultingJson.getNode().add((Object)subObject);
                this.getIndexKeys(document, resultingJson);
            } else {
                this.addDataTypeToJson((String)key, val, resultingJson);
            }
        });
    }
}

